'use strict';

var datasets = {
    "full-chile-fishing-vessels": {
        name: "智利船舶监控系统（渔船）",
        description: "智利船舶监控系统数据集（公开）",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    industry: "工业",
                    small_fisheries: "小规模渔业"
                }
            },
            source: "来源"
        }
    },
    "full-indonesia-fishing-vessels": {
        name: "印度尼西亚船舶监控系统（渔船）",
        description: "印度尼西亚船舶监控系统数据集（公开）",
        schema: {
            source: "来源"
        }
    },
    "full-panama-fishing-vessels": {
        name: "巴拿马船舶监控系统（完整渔船）",
        description: "巴拿马船舶监控系统数据集（公开）",
        schema: {
            length: "长度",
            source: "来源"
        }
    },
    "full-peru-fishing-vessels": {
        name: "秘鲁船舶监控系统（渔船）",
        description: "秘鲁船舶监控系统数据集（公开）",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    industrial: "工业",
                    artisanal: "手工",
                    "not defined": "未定义"
                }
            },
            length: "长度",
            origin: {
                keyword: "来源地",
                "enum": {
                    Peru: "秘鲁",
                    Foreign: "外国"
                }
            },
            source: "来源"
        }
    },
    "private-belize-fishing-effort": {
        name: "伯利兹船舶监控系统",
        description: "船舶监控系统（VMS）数据由伯利兹公海渔业部门（BHSFU）提供。数据通过伯利兹的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为表观捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热力图上。VMS的数据广播方式与AIS不同，可能提供不同的完整性、准确性和质量度量。海洋渔业观察正在不断改进其跨所有广播数据格式的算法，以算法方式识别\"表观捕捞活动\"。可能存在一些捕捞活动未被识别，或者热力图可能显示实际未发生捕捞时的表观捕捞活动。出于这些原因，海洋渔业观察将\"捕捞活动\"、\"捕捞\"或\"捕捞努力量\"等术语限定为表观而非确定。任何和所有海洋渔业观察关于\"表观捕捞活动\"的信息都应被视为估计值，必须由用户自行决定是否依赖。海洋渔业观察的捕捞存在算法使用观察者收集的实际捕捞事件数据开发和测试，并结合对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕捞活动分类数据并改进自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "private-belize-fishing-vessels": {
        name: "伯利兹船舶监控系统（渔船）",
        description: "渔船（伯利兹船舶监控系统）",
        schema: {
            source: "来源"
        }
    },
    "private-belize-non-fishing-vessels": {
        name: "伯利兹船舶监控系统（非渔船）",
        description: "非渔船（伯利兹船舶监控系统）",
        schema: {
            source: "来源"
        }
    },
    "private-belize-presence": {
        name: "伯利兹船舶监控系统",
        description: "存在数据（伯利兹私有）",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "private-belize-vessel-identity-fishing": {
        name: "伯利兹船舶监控系统",
        description: "船舶身份"
    },
    "private-belize-vessel-identity-non-fishing": {
        name: "伯利兹船舶监控系统",
        description: "船舶身份"
    },
    "private-belize-vessel-identity": {
        name: "伯利兹船舶监控系统",
        description: "船舶身份"
    },
    "private-bra-onyxsat-fishing-effort": {
        name: "巴西船舶监控系统",
        description: "船舶监控系统（VMS）数据由巴西水产养殖和渔业部提供。数据通过巴西的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶身份、位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为表观捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热力图上。VMS的数据广播方式与AIS不同，可能提供不同的完整性、准确性和质量度量。海洋渔业观察正在不断改进其跨所有广播数据格式的算法，以算法方式识别\"表观捕捞活动\"。可能存在一些捕捞活动未被识别，或者热力图可能显示实际未发生捕捞时的表观捕捞活动。出于这些原因，海洋渔业观察将\"捕捞活动\"、\"捕捞\"或\"捕捞努力量\"等术语限定为表观而非确定。任何和所有海洋渔业观察关于\"表观捕捞活动\"的信息都应被视为估计值，必须由用户自行决定是否依赖。海洋渔业观察的捕捞检测算法使用观察者收集的实际捕捞事件数据开发和测试，并结合对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕捞活动分类数据并改进自动分类技术。",
        schema: {
            target_species: {
                keyword: "目标物种",
                "enum": {
                    "Sardinha-verdadeira e Bonito-listrado": "巴西沙丁鱼和鲣鱼",
                    Polvo: "章鱼",
                    "Caranguejo-vermelho": "西南大西洋红蟹",
                    "Sardinha-verdadeira e Anchova": "巴西沙丁鱼和鳀鱼",
                    "peixes diversos": "杂鱼类",
                    "Sardinha-laje": "大西洋圆腹鲱",
                    "Pescada-gó": "犬牙石首鱼",
                    "Piramutaba e peixes diversos": "拉劳鲶鱼和杂鱼类",
                    "Corvina; Pescadas; Castanha e Abrótea": "白口石首鱼；石首鱼类；阿根廷石首鱼；巴西鳕鱼",
                    "Fundo e Superfície": "底层和表层",
                    "permissionamento antigo; em processo de conversão": "旧许可；转换中",
                    "Tainhas; Anchova e Serras": "鲻鱼；鳀鱼；锯鳐",
                    "Garoupas; Cherne; Sirigado e outros peixes de fundo": "石斑鱼；黑石斑鱼；其他底层鱼类",
                    "Sardinha-verdadeira e Tainha": "巴西沙丁鱼和灰鲻鱼",
                    Lagostas: "龙虾",
                    "Espadarte - atuns e afins": "剑鱼；金枪鱼及类似鱼类",
                    "Camarão-rosa e peixes diversos": "粉红虾和杂鱼类",
                    "Pescada Amarela": "美洲犬牙石首鱼",
                    "Peixe-sapo": "安康鱼",
                    "Piramutaba; Dourada e Gurijuba": "拉劳鲶鱼；金鲷；鳃背海鲶",
                    Pargo: "红笛鲷",
                    Serras: "锯鳐",
                    "Cavala e Albacorinha": "刺鲅和黑鳍金枪鱼",
                    "Camarão-sete-barbas": "海螯虾",
                    "Bonito-listrado": "鲣鱼",
                    "camarões": "杂虾类",
                    "Abrótea; Galo e Merluza": "巴西鳕鱼；月鲹；阿根廷无须鳕",
                    "peixes demersais": "底层鱼类",
                    " Camarão-rosa": "粉红虾",
                    "Dourado - atuns e afins": "鬼头刀；金枪鱼及类似鱼类",
                    "Albacoras - atuns e afins": "金枪鱼及类似鱼类"
                }
            },
            license_category: {
                keyword: "许可证类别",
                "enum": {
                    Cerco: "围网",
                    Armadilhas: "陷阱",
                    "Rede de emalhe": "刺网",
                    Linha: "延绳钓",
                    Arrasto: "拖网"
                }
            }
        }
    },
    "private-bra-onyxsat-fishing-vessels": {
        name: "巴西船舶监控系统（渔船）",
        description: "渔船（巴西船舶监控系统）",
        schema: {
            source: "来源",
            codMarinha: "海洋代码",
            fishingZone: "捕捞区域",
            licenseCode: "许可证代码",
            targetSpecies: {
                keyword: "目标物种",
                "enum": {
                    "Sardinha-verdadeira e Bonito-listrado": "巴西沙丁鱼和鲣鱼",
                    Polvo: "章鱼",
                    "Caranguejo-vermelho": "西南大西洋红蟹",
                    "Sardinha-verdadeira e Anchova": "巴西沙丁鱼和鳀鱼",
                    "peixes diversos": "杂鱼类",
                    "Sardinha-laje": "大西洋圆腹鲱",
                    "Pescada-gó": "犬牙石首鱼",
                    "Piramutaba e peixes diversos": "拉劳鲶鱼和杂鱼类",
                    "Corvina; Pescadas; Castanha e Abrótea": "白口石首鱼；石首鱼类；阿根廷石首鱼；巴西鳕鱼",
                    "Fundo e Superfície": "底层和表层",
                    "permissionamento antigo; em processo de conversão": "旧许可；转换中",
                    "Tainhas; Anchova e Serras": "鲻鱼；鳀鱼；锯鳐",
                    "Garoupas; Cherne; Sirigado e outros peixes de fundo": "石斑鱼；黑石斑鱼；其他底层鱼类",
                    "Sardinha-verdadeira e Tainha": "巴西沙丁鱼和灰鲻鱼",
                    Lagostas: "龙虾",
                    "Espadarte - atuns e afins": "剑鱼；金枪鱼及类似鱼类",
                    "Camarão-rosa e peixes diversos": "粉红虾和杂鱼类",
                    "Pescada Amarela": "美洲犬牙石首鱼",
                    "Peixe-sapo": "安康鱼",
                    "Piramutaba; Dourada e Gurijuba": "拉劳鲶鱼；金鲷；鳃背海鲶",
                    Pargo: "红笛鲷",
                    Serras: "锯鳐",
                    "Cavala e Albacorinha": "刺鲅和黑鳍金枪鱼",
                    "Camarão-sete-barbas": "海螯虾",
                    "Bonito-listrado": "鲣鱼",
                    "camarões": "杂虾类",
                    "Abrótea; Galo e Merluza": "巴西鳕鱼；月鲹；阿根廷无须鳕",
                    "peixes demersais": "底层鱼类",
                    " Camarão-rosa": "粉红虾",
                    "Dourado - atuns e afins": "鬼头刀；金枪鱼及类似鱼类",
                    "Albacoras - atuns e afins": "金枪鱼及类似鱼类"
                }
            },
            licensDescription: "许可证描述"
        }
    },
    "private-bra-onyxsat-non-fishing-vessels": {
        name: "巴西船舶监控系统（非渔船）",
        description: "非渔船（巴西船舶监控系统）",
        schema: {
            source: "来源",
            codMarinha: "海洋代码",
            fishingZone: "捕捞区域",
            licenseCode: "许可证代码",
            targetSpecies: {
                keyword: "目标物种",
                "enum": {
                    "Sardinha-verdadeira e Bonito-listrado": "巴西沙丁鱼和鲣鱼",
                    Polvo: "章鱼",
                    "Caranguejo-vermelho": "西南大西洋红蟹",
                    "Sardinha-verdadeira e Anchova": "巴西沙丁鱼和鳀鱼",
                    "peixes diversos": "杂鱼类",
                    "Sardinha-laje": "大西洋圆腹鲱",
                    "Pescada-gó": "犬牙石首鱼",
                    "Piramutaba e peixes diversos": "拉劳鲶鱼和杂鱼类",
                    "Corvina; Pescadas; Castanha e Abrótea": "白口石首鱼；石首鱼类；阿根廷石首鱼；巴西鳕鱼",
                    "Fundo e Superfície": "底层和表层",
                    "permissionamento antigo; em processo de conversão": "旧许可；转换中",
                    "Tainhas; Anchova e Serras": "鲻鱼；鳀鱼；锯鳐",
                    "Garoupas; Cherne; Sirigado e outros peixes de fundo": "石斑鱼；黑石斑鱼；其他底层鱼类",
                    "Sardinha-verdadeira e Tainha": "巴西沙丁鱼和灰鲻鱼",
                    Lagostas: "龙虾",
                    "Espadarte - atuns e afins": "剑鱼；金枪鱼及类似鱼类",
                    "Camarão-rosa e peixes diversos": "粉红虾和杂鱼类",
                    "Pescada Amarela": "美洲犬牙石首鱼",
                    "Peixe-sapo": "安康鱼",
                    "Piramutaba; Dourada e Gurijuba": "拉劳鲶鱼；金鲷；鳃背海鲶",
                    Pargo: "红笛鲷",
                    Serras: "锯鳐",
                    "Cavala e Albacorinha": "刺鲅和黑鳍金枪鱼",
                    "Camarão-sete-barbas": "海螯虾",
                    "Bonito-listrado": "鲣鱼",
                    "camarões": "杂虾类",
                    "Abrótea; Galo e Merluza": "巴西鳕鱼；月鲹；阿根廷无须鳕",
                    "peixes demersais": "底层鱼类",
                    " Camarão-rosa": "粉红虾",
                    "Dourado - atuns e afins": "鬼头刀；金枪鱼及类似鱼类",
                    "Albacoras - atuns e afins": "金枪鱼及类似鱼类"
                }
            },
            licensDescription: "许可证描述"
        }
    },
    "private-bra-onyxsat-presence": {
        name: "巴西船舶监控系统",
        description: "存在数据（巴西私有）",
        schema: {
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    fishing: "捕捞",
                    "non-fishing": "非捕捞"
                }
            }
        }
    },
    "private-bra-onyxsat-vessel-identity-fishing": {
        name: "巴西船舶监控系统（渔船）",
        description: "渔船（巴西船舶监控系统）"
    },
    "private-bra-onyxsat-vessel-identity-non-fishing": {
        name: "巴西船舶监控系统（非渔船）",
        description: "非渔船（巴西船舶监控系统）"
    },
    "private-brazil-opentuna-presence": {
        name: "巴西开放金枪鱼船舶监控系统",
        description: "海洋渔业观察的这一层使用由大西洋可持续金枪鱼联盟（AASF）提供的数据，该联盟是一组决定保持透明的巴西私有金枪鱼公司，更多信息见此处。数据通过其船舶监控系统（VMS）经卫星收集，包括船舶识别、位置、速度和航向。显示的信息代表船舶存在数据。"
    },
    "private-costa-rica-fishing-effort": {
        name: "哥斯达黎加船舶监控系统",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过厄瓜多尔的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为表观捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热力图上。VMS的数据广播方式与AIS不同，可能提供不同的完整性、准确性和质量度量。海洋渔业观察正在不断改进其跨所有广播数据格式的算法，以算法方式识别\"表观捕捞活动\"。可能存在一些捕捞活动未被识别，或者热力图可能显示实际未发生捕捞时的表观捕捞活动。出于这些原因，海洋渔业观察将\"捕捞活动\"、\"捕捞\"或\"捕捞努力量\"等术语限定为表观而非确定。任何和所有海洋渔业观察关于\"表观捕捞活动\"的信息都应被视为估计值，必须由用户自行决定是否依赖。海洋渔业观察的捕捞检测算法使用观察者收集的实际捕捞事件数据开发和测试，并结合对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕捞活动分类数据并改进自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    costarica_vms_industrial_longline: "哥斯达黎加船舶监控系统工业延绳钓",
                    costarica_vms_atuneros: "哥斯达黎加船舶监控系统金枪鱼船",
                    costarica_vms_sardineros: "哥斯达黎加船舶监控系统沙丁鱼船"
                }
            }
        }
    },
    "private-costa-rica-presence": {
        name: "哥斯达黎加船舶监控系统",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过厄瓜多尔的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为表观捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热力图上。VMS的数据广播方式与AIS不同，可能提供不同的完整性、准确性和质量度量。海洋渔业观察正在不断改进其跨所有广播数据格式的算法，以算法方式识别\"表观捕捞活动\"。可能存在一些捕捞活动未被识别，或者热力图可能显示实际未发生捕捞时的表观捕捞活动。出于这些原因，海洋渔业观察将\"捕捞活动\"、\"捕捞\"或\"捕捞努力量\"等术语限定为表观而非确定。任何和所有海洋渔业观察关于\"表观捕捞活动\"的信息都应被视为估计值，必须由用户自行决定是否依赖。海洋渔业观察的捕捞检测算法使用观察者收集的实际捕捞事件数据开发和测试，并结合对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕捞活动分类数据并改进自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    costarica_vms_industrial_longline: "哥斯达黎加船舶监控系统工业延绳钓",
                    costarica_vms_atuneros: "哥斯达黎加船舶监控系统金枪鱼船",
                    costarica_vms_sardineros: "哥斯达黎加船舶监控系统沙丁鱼船"
                }
            },
            speed: "速度",
            bearing: "航向"
        }
    },
    "private-ecuador-fishing-effort": {
        name: "厄瓜多尔船舶监控系统",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过厄瓜多尔的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为表观捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热力图上。VMS的数据广播方式与AIS不同，可能提供不同的完整性、准确性和质量度量。海洋渔业观察正在不断改进其跨所有广播数据格式的算法，以算法方式识别\"表观捕捞活动\"。可能存在一些捕捞活动未被识别，或者热力图可能显示实际未发生捕捞时的表观捕捞活动。出于这些原因，海洋渔业观察将\"捕捞活动\"、\"捕捞\"或\"捕捞努力量\"等术语限定为表观而非确定。任何和所有海洋渔业观察关于\"表观捕捞活动\"的信息都应被视为估计值，必须由用户自行决定是否依赖。海洋渔业观察的捕捞检测算法使用观察者收集的实际捕捞事件数据开发和测试，并结合对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕捞活动分类数据并改进自动分类技术。",
        schema: {
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    fishing: "捕捞"
                }
            }
        }
    },
    "private-ecuador-presence": {
        name: "厄瓜多尔船舶监控系统",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过厄瓜多尔的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为表观捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热力图上。VMS的数据广播方式与AIS不同，可能提供不同的完整性、准确性和质量度量。海洋渔业观察正在不断改进其跨所有广播数据格式的算法，以算法方式识别\"表观捕捞活动\"。可能存在一些捕捞活动未被识别，或者热力图可能显示实际未发生捕捞时的表观捕捞活动。出于这些原因，海洋渔业观察将\"捕捞活动\"、\"捕捞\"或\"捕捞努力量\"等术语限定为表观而非确定。任何和所有海洋渔业观察关于\"表观捕捞活动\"的信息都应被视为估计值，必须由用户自行决定是否依赖。海洋渔业观察的捕捞检测算法使用观察者收集的实际捕捞事件数据开发和测试，并结合对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕捞活动分类数据并改进自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "航向",
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    fishing: "捕捞",
                    "international traffic": "国际交通",
                    "national traffic": "国内交通",
                    tug: "拖船",
                    boat: "小船",
                    auxiliary: "辅助船"
                }
            }
        }
    },
    "private-global-other-vessels": {
        name: "AIS（其他船舶）",
        description: "船舶自动识别系统（AIS）其他船舶",
        schema: {
            source: "来源"
        }
    },
    "private-global-presence-tracks": {
        name: "航迹",
        description: "该数据集包含所有船舶的自动识别系统（AIS）航迹 - 版本20201001",
        schema: {
            speed: {
                keyword: "速度",
                "enum": {
                    "0": "0",
                    "20": "20"
                }
            }
        }
    },
    "private-indonesia-aruna-fishing-effort": {
        name: "Aruna：印度尼西亚远洋",
        description: "印度尼西亚阿茹纳（Aruna）捕捞努力量"
    },
    "private-indonesia-aruna-presence": {
        name: "Aruna：印度尼西亚远洋",
        description: "阿茹纳（Aruna）存在数据",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "private-indonesia-aruna-vessel-identity": {
        name: "印度尼西亚Aruna（船舶）",
        description: "船舶（印度尼西亚阿茹纳，Aruna）"
    },
    "private-indonesia-aruna-vessels": {
        name: "印度尼西亚Aruna（船舶）",
        description: "船舶（印度尼西亚阿茹纳，Aruna）",
        schema: {
            source: "来源"
        }
    },
    "private-indonesia-fishing-effort": {
        name: "印度尼西亚船舶监控系统",
        description: "印度尼西亚的船舶监控系统（VMS）数据目前无法获取2020年7月以后的时期。\n\n船舶监控系统（VMS）数据由印度尼西亚政府海事和渔业部提供。数据通过卫星和地面接收器使用其VMS收集，包含船舶身份、渔具类型、位置、速度、方向等信息。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将这些船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。\n\nVMS的数据广播方式与AIS有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼存在算法（与AIS一样）是通过算法识别\"明显捕鱼活动\"的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为\"明显\"而非确定的。\n\n任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。海洋渔业观察的捕鱼存在算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。"
    },
    "private-indonesia-fishing-vessels": {
        name: "印度尼西亚船舶监控系统（渔船）",
        description: "印度尼西亚船舶监控系统数据集（私有）"
    },
    "private-indonesia-ipnlf-fishing-effort": {
        name: "AP2HI-IPNLF：印度尼西亚远洋",
        description: "印度尼西亚金枪鱼延绳钓协会-印度洋金枪鱼类养护委员会（AP2HI-IPNLF）捕捞努力量"
    },
    "private-indonesia-ipnlf-presence": {
        name: "AP2HI-IPNLF：印度尼西亚远洋",
        description: "印度尼西亚金枪鱼延绳钓协会-印度洋金枪鱼类养护委员会（AP2HI-IPNLF）存在数据",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "private-indonesia-ipnlf-vessel-identity": {
        name: "印度尼西亚AP2HI-IPNLF（船舶）",
        description: "船舶（印度尼西亚金枪鱼延绳钓协会-印度洋金枪鱼类养护委员会，AP2HI-IPNLF）"
    },
    "private-indonesia-ipnlf-vessels": {
        name: "印度尼西亚AP2HI-IPNLF（船舶）",
        description: "船舶（印度尼西亚金枪鱼延绳钓协会-印度洋金枪鱼类养护委员会，AP2HI-IPNLF）",
        schema: {
            source: "来源"
        }
    },
    "private-indonesia-pelagic-fishing-effort": {
        name: "印度尼西亚远洋（试点）",
        description: "印度尼西亚远洋捕捞努力量私有数据"
    },
    "private-indonesia-pelagic-presence": {
        name: "印度尼西亚远洋（试点）",
        description: "海洋渔业观察的这一层使用由Rare组织、阿茹纳（Aruna）和印度尼西亚金枪鱼延绳钓协会（AP2HI）提供的数据。数据通过远洋设备收集，跟踪位置和速度。显示的信息代表船舶存在数据。存在数据通过每小时获取一次船舶跟踪设备传输的位置来确定。"
    },
    "private-indonesia-pelagic-vessel-identity": {
        name: "印度尼西亚远洋（船舶）",
        description: "船舶（印度尼西亚远洋）"
    },
    "private-indonesia-pelagic-vessels": {
        name: "印度尼西亚远洋（船舶）",
        description: "船舶（印度尼西亚远洋）",
        schema: {
            source: "来源"
        }
    },
    "private-indonesia-presence": {
        name: "印度尼西亚船舶监控系统",
        description: "船舶存在数据",
        schema: {
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    "Cast Nets": "投网",
                    "Anchored gillnets": "定置刺网",
                    "Shrimp net": "虾网",
                    "Purse Seine Big Pelagics with one boat": "单船大型中上层围网",
                    Transporter: "运输船",
                    "Basic longline": "基础延绳钓",
                    "Pole-and-line": "竿钓",
                    "Hand Line Tuna": "金枪鱼手钓",
                    Handline: "手钓",
                    "Purse Seine Small Pelagics": "小型中上层围网",
                    "Stick-Held lift net": "撑杆抬网",
                    "Longline Tuna": "金枪鱼延绳钓",
                    "Oceanic gillnet": "大洋刺网",
                    "Fish net/dragnet": "鱼网/拖网",
                    "Squid hooking": "鱿鱼钩钓"
                }
            }
        }
    },
    "private-indonesia-rare-fishing-effort": {
        name: "Rare：印度尼西亚远洋",
        description: "印度尼西亚Rare组织捕捞努力量"
    },
    "private-indonesia-rare-presence": {
        name: "Rare：印度尼西亚远洋",
        description: "Rare组织存在数据",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "private-indonesia-rare-vessel-identity": {
        name: "印度尼西亚稀有（船舶）",
        description: "船舶（印度尼西亚Rare组织）"
    },
    "private-indonesia-rare-vessels": {
        name: "印度尼西亚稀有（船舶）",
        description: "船舶（印度尼西亚Rare组织）",
        schema: {
            source: "来源"
        }
    },
    "private-indonesia-zebrax-presence": {
        name: "印度尼西亚Zebrax（私有）",
        description: "海洋渔业观察的这一层使用由Rare组织、阿茹纳（Aruna）和印度尼西亚金枪鱼延绳钓协会（AP2HI）提供的数据。数据通过不同供应商的设备收集，跟踪位置和速度。显示的信息代表船舶存在数据。存在数据通过获取船舶跟踪设备传输的所有位置来确定。",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "private-indonesia-zebrax-vessel-identity": {
        name: "印度尼西亚沿海渔业",
        description: "海洋渔业观察的这一层使用由Rare组织、阿茹纳（Aruna）和印度尼西亚金枪鱼延绳钓协会（AP2HI）提供的数据。"
    },
    "private-indonesia-zebrax-vessels": {
        name: "印度尼西亚沿海渔业",
        description: "海洋渔业观察的这一层使用由Rare组织、阿茹纳（Aruna）和印度尼西亚金枪鱼延绳钓协会（AP2HI）提供的数据。",
        schema: {
            source: "来源"
        }
    },
    "private-norway-fishing-effort": {
        name: "挪威VMS",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过厄瓜多尔的船舶监控系统经卫星收集，并在三天后发布，包含船舶位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。VMS与AIS的数据广播方式不同，可能在完整性、准确性和质量方面给出不同的衡量标准。海洋渔业观察持续改进其在所有广播数据格式中的算法，以通过算法识别“明显捕鱼活动”。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。出于这些原因，海洋渔业观察将“捕鱼活动”、“捕鱼”或“捕鱼努力”等术语限定为明显而非确定的。任何和所有关于“明显捕鱼活动”的海洋渔业观察信息都应被视为估计值，用户必须自行决定是否依赖。海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据并改进自动分类技术"
    },
    "private-panama-fishing-effort": {
        name: "巴拿马VMS",
        description: "船舶监控系统（VMS）数据由巴拿马水产资源局（ARAP）提供。数据通过卫星由巴拿马的VMS系统接收，包含船舶身份、渔具类型、位置、速度、方向等信息。巴拿马的运输船数据也可在此处获取。运输船数据层中的每个点代表运输船的一个位置，但并非所有位置都显示。运输船位置每天显示一次。在未来，我们预计能够显示更多位置。点击运输船的位置可查看船舶的完整航迹。\n\n海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。\n\nVMS的数据广播方式与AIS有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼检测算法（与AIS一样）是通过算法识别\"明显捕鱼活动\"的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。\n\n出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为\"明显\"而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。\n\n海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。"
    },
    "private-panama-fishing-vessels": {
        name: "巴拿马私有VMS（私有渔船）",
        description: "巴拿马VMS数据集（私有）",
        schema: {
            length: "长度",
            source: "来源"
        }
    },
    "private-panama-non-fishing-vessels": {
        name: "巴拿马私有VMS（私有非渔船）",
        description: "巴拿马VMS数据集（私有）",
        schema: {
            source: "来源"
        }
    },
    "private-panama-presence": {
        name: "巴拿马VMS",
        description: "该图层使用由巴拿马水产资源局（ARAP）提供的船舶监控系统（VMS）数据。数据通过卫星由巴拿马的VMS系统接收，包含船舶身份、渔具类型、位置、速度、方向等信息。运输船数据层中的每个点代表运输船的一个位置，但并非所有位置都显示。运输船位置每天显示一次。点击运输船的位置可查看船舶的完整航迹。",
        schema: {
            speed: "速度",
            bearing: "方位角",
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    carrier: "运输船",
                    fishing: "渔船",
                    oil_tanker: "油轮"
                }
            }
        }
    },
    "private-panama-vessel-identity-fishing": {
        name: "巴拿马私有VMS（私有渔船）",
        description: "巴拿马VMS数据集（私有）"
    },
    "private-panama-vessel-identity-non-fishing": {
        name: "巴拿马私有VMS（私有非渔船）",
        description: "巴拿马VMS数据集（私有）"
    },
    "private-peru-fishing-effort": {
        name: "秘鲁VMS",
        description: "船舶监控系统（VMS）数据由秘鲁政府生产部渔业部门（PRODUCE）提供。包含秘鲁数据需要实施10天的发布延迟。数据通过卫星和地面接收器使用其船舶监控系统（VMS）收集，包含船舶身份、渔具类型、位置、速度、方向等信息。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将这些船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。VMS与AIS的数据广播方式有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼检测算法（与AIS算法一样）是通过算法识别“明显捕鱼活动”的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。出于这些原因，海洋渔业观察将“捕鱼活动”、“捕鱼”或“捕鱼努力”等术语限定为“明显”而非确定的。任何/所有关于“明显捕鱼活动”的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    industrial: "工业船队",
                    artisanal: "手工渔业",
                    "small-scale": "小型渔业",
                    "not defined": "未定义"
                }
            },
            origin: {
                keyword: "来源地",
                "enum": {
                    PER: "秘鲁",
                    Foreign: "外国"
                }
            }
        }
    },
    "private-peru-fishing-vessels": {
        name: "秘鲁私有VMS（渔船）",
        description: "秘鲁VMS数据集（私有）",
        schema: {
            casco: {
                keyword: "船体材料",
                "enum": {
                    "ACERO NAVAL": "船用钢材",
                    MADERA: "木材",
                    "N/E": "无数据",
                    NONE: "无",
                    "FIBRA DE VIDRIO": "玻璃钢"
                }
            },
            fleet: {
                keyword: "船队",
                "enum": {
                    industrial: "工业船队",
                    artisanal: "手工渔业",
                    "not defined": "未定义"
                }
            },
            length: "长度",
            origin: {
                keyword: "来源地",
                "enum": {
                    Peru: "秘鲁",
                    Foreign: "外国"
                }
            },
            source: "来源",
            chdSpecies: "目标物种"
        }
    },
    "private-peru-presence": {
        name: "秘鲁VMS",
        description: "船舶监控系统（VMS）数据由秘鲁政府生产部渔业部门（PRODUCE）提供。包含秘鲁数据需要实施10天的发布延迟。数据通过卫星和地面接收器使用其船舶监控系统（VMS）收集，包含船舶身份、渔具类型、位置、速度、方向等信息。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将这些船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。VMS与AIS的数据广播方式有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼检测算法（与AIS算法一样）是通过算法识别“明显捕鱼活动”的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。出于这些原因，海洋渔业观察将“捕鱼活动”、“捕鱼”或“捕鱼努力”等术语限定为“明显”而非确定的。任何/所有关于“明显捕鱼活动”的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    industrial: "工业船队",
                    artisanal: "手工渔业",
                    "small-scale": "小型渔业",
                    "not defined": "未定义"
                }
            },
            origin: {
                keyword: "来源地",
                "enum": {
                    PER: "秘鲁",
                    Foreign: "外国"
                }
            }
        }
    },
    "private-peru-vessel-identity-fishing": {
        name: "秘鲁私有VMS（渔船）",
        description: "秘鲁VMS数据集（私有）"
    },
    "private-png-fishing-effort": {
        name: "巴布亚新几内亚VMS",
        description: "船舶监控系统（VMS）数据由巴布亚新几内亚国家渔业局提供。数据通过卫星使用巴布亚新几内亚的船舶监控（VMS）系统收集，包含船舶标识符和位置，并在五天延迟后发布。海洋渔业观察为每个船舶位置推断速度和航向，并使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。VMS与AIS的数据广播方式不同，可能在完整性、准确性和质量方面给出不同的衡量标准。海洋渔业观察持续改进其在所有广播数据格式中的算法，以算法方式识别“明显捕鱼活动”。可能存在一些捕鱼活动未被识别，或者热图可能显示实际未发生捕鱼时的明显捕鱼活动。出于这些原因，海洋渔业观察将“捕鱼活动”、“捕鱼”或“捕鱼努力”等术语限定为明显而非确定。任何和所有关于“明显捕鱼活动”的海洋渔业观察信息都应被视为估计值，用户必须自行决定是否依赖。海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据并改进自动分类技术",
        schema: {
            speed: "速度",
            bearing: "方位角"
        }
    },
    "private-png-fishing-identity-vessels": {
        name: "巴布亚新几内亚VMS（渔船）",
        description: "巴布亚新几内亚VMS数据集（私有）"
    },
    "private-png-fishing-vessels": {
        name: "巴布亚新几内亚VMS（渔船）",
        description: "巴布亚新几内亚VMS数据集（私有）",
        schema: {
            source: "来源"
        }
    },
    "private-png-presence": {
        name: "巴布亚新几内亚VMS",
        description: "船舶监控系统（VMS）数据由巴布亚新几内亚国家渔业局提供。数据使用由渔业信息和管理系统（FIMS）提供的巴布亚新几内亚国家VMS收集。VMS数据包括船舶标识符和位置，并在五天延迟后发布。\n\n活动图层显示船舶存在的热力图。存在情况是通过从船舶VMS传输的位置中每小时每艘船舶选取两个位置来确定的。",
        schema: {
            speed: "速度",
            bearing: "方位角"
        }
    },
    "proto-global-encounters-events-30min": {
        name: "原型 - 30分钟相遇事件（AIS）",
        description: "该数据集包含AIS的30分钟相遇事件。[渔船-运输船、运输船-渔船、支持船-渔船、渔船-支持船]",
        schema: {
            duration: "持续时间"
        }
    },
    "proto-global-encounters-events": {
        name: "相遇事件（AIS）",
        description: "该数据集包含带有授权的AIS相遇事件。[渔船-运输船、运输船-渔船、支持船-渔船、渔船-支持船]"
    },
    "public-ais-presence-viirs-match-prototype": {
        name: "VIIRS夜间灯光船舶探测",
        description: "夜间灯光船舶探测图层，又称可见红外成像辐射仪套件（VIIRS），显示卫星通过夜间船只发出的光线探测到的海上船只。虽然这一活动图层并不仅与渔船相关，但很可能显示与鱿鱼捕捞等活动相关的船只，这些船只使用明亮的灯光在夜间作业。<br/>\n<br/>\n基于Suomi NPP卫星，VIIRS传感器每晚至少扫描整个地球一次，探测灯光以提供全球至少一次的每日观测。由于极地轨道卫星的轨道设计，靠近极地的地区每天会有更多次过境，而赤道地区每天只有一次过境。<br/> \n<br/>\n由于船只仅基于光发射被探测到，我们可以探测到可能不广播身份信息的单个船只甚至整个捕鱼船队，因此这些船只可能不会在海洋渔业观察地图上的其他地方显示。海洋渔业观察接收由美国国家海洋和大气管理局（NOAA）VIIRS收集的微光成像数据处理后的船只探测结果。船只探测结果由科罗拉多矿业大学的地球观测小组（<a href='https://eogdata.mines.edu/products/vbd/' target='_blank' rel=noopener'>Earth Observation Group</a>）近实时处理。这些被称为VIIRS船只探测的数据记录了船只的存在，包括那些使用灯光吸引渔获或在夜间进行作业的船只。来自固定海上基础设施和其他非船只来源的灯光被排除在外。了解更多关于VIIRS夜间灯光船只探测的信息，并下载<a href='https://eogdata.mines.edu/products/vbd/' target='_blank' rel=noopener'>数据</a>。<br/>\n<br/>\n海洋渔业观察开发了一套复杂的系统，将可用的自动识别系统（AIS）数据与相应的夜间灯光船只探测结果进行匹配。这种匹配使用概率模型，该模型基于卫星VIIRS图像拍摄前后的所有可用AIS记录，以及将特定AIS消息与该图像上出现的任何船只配对的概率，来确定AIS消息/VIIRS探测对。利用这些信息，海洋渔业观察在VIIRS活动图层中增加了根据船只类型和渔具类型过滤探测结果的实验性功能。<br/>\n<br/>\n超过85%的探测结果来自缺乏AIS或公开共享的船舶监控系统（VMS）应答器的船只。VIIRS图层的全球添加使您能够快速过滤与AIS匹配或未匹配的夜间灯光探测结果，其中船只识别信息可用。<br/>\n<br/>\n辐射亮度表示VIIRS传感器接收到的光源亮度。辐射亮度受月球、云层和船只相对于卫星的角度影响。两艘具有相同亮度或光强度的船只，根据条件可能具有不同的辐射亮度水平。一般来说，不使用灯光主动捕鱼的船只可能具有较低的辐射亮度水平。当船只接近海岸线时，应考虑例外情况。为了进一步探索船只夜间灯光如何发出不同的辐射亮度水平，VIIRS活动图层可以过滤到与不同人类行为相关的特定兴趣范围。<br/>\n<br/>\n使用夜间灯光探测数据的人应考虑南大西洋异常区（SAA），这是地球内范艾伦辐射带海拔最低的区域，允许更多来自太空的高能粒子穿透。当这些粒子撞击卫星上的传感器时，可能会产生错误信号，导致算法将其识别为船只探测。已经应用了过滤算法，但仍可能存在一些误识别。",
        schema: {
            matched: {
                keyword: "匹配状态",
                "enum": {
                    "true": "匹配",
                    "false": "未匹配"
                }
            },
            radiance: {
                keyword: "辐射亮度",
                "enum": {
                    "0": "0",
                    "10000": "10000"
                }
            },
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    unknown: "未知",
                    fishing: "渔船",
                    carrier: "运输船",
                    support: "支持船"
                }
            },
            qf_detect: {
                keyword: "检测质量标志",
                "enum": {
                    "1": "1",
                    "2": "2",
                    "3": "3",
                    "5": "5",
                    "7": "7",
                    "10": "10"
                }
            }
        }
    },
    "public-ais-presence-viirs-match": {
        name: "VIIRS夜间灯光船舶探测",
        description: "夜间灯光船舶探测图层，又称可见红外成像辐射仪套件（VIIRS），显示卫星通过夜间船只发出的光线探测到的海上船只。虽然这一活动图层并不仅与渔船相关，但很可能显示与鱿鱼捕捞等活动相关的船只，这些船只使用明亮的灯光在夜间作业。<br/>\n<br/>\n基于Suomi NPP卫星，VIIRS传感器每晚至少扫描整个地球一次，探测灯光以提供全球至少一次的每日观测。由于极地轨道卫星的轨道设计，靠近极地的地区每天会有更多次过境，而赤道地区每天只有一次过境。<br/> \n<br/>\n由于船只仅基于光发射被探测到，我们可以探测到可能不广播身份信息的单个船只甚至整个捕鱼船队，因此这些船只可能不会在海洋渔业观察地图上的其他地方显示。海洋渔业观察接收由美国国家海洋和大气管理局（NOAA）VIIRS收集的微光成像数据处理后的船只探测结果。船只探测结果由科罗拉多矿业大学的地球观测小组（<a href='https://eogdata.mines.edu/products/vbd/' target='_blank' rel=noopener'>Earth Observation Group</a>）近实时处理。这些被称为VIIRS船只探测的数据记录了船只的存在，包括那些使用灯光吸引渔获或在夜间进行作业的船只。来自固定海上基础设施和其他非船只来源的灯光被排除在外。了解更多关于VIIRS夜间灯光船只探测的信息，并下载<a href='https://eogdata.mines.edu/products/vbd/' target='_blank' rel=noopener'>数据</a>。<br/>\n<br/>\n海洋渔业观察开发了一套复杂的系统，将可用的自动识别系统（AIS）数据与相应的夜间灯光船只探测结果进行匹配。这种匹配使用概率模型，该模型基于卫星VIIRS图像拍摄前后的所有可用AIS记录，以及将特定AIS消息与该图像上出现的任何船只配对的概率，来确定AIS消息/VIIRS探测对。利用这些信息，海洋渔业观察在VIIRS活动图层中增加了根据船只类型和渔具类型过滤探测结果的实验性功能。<br/>\n<br/>\n超过85%的探测结果来自缺乏AIS或公开共享的船舶监控系统（VMS）应答器的船只。VIIRS图层的全球添加使您能够快速过滤与AIS匹配或未匹配的夜间灯光探测结果，其中船只识别信息可用。<br/>\n<br/>\n辐射亮度表示VIIRS传感器接收到的光源亮度。辐射亮度受月球、云层和船只相对于卫星的角度影响。两艘具有相同亮度或光强度的船只，根据条件可能具有不同的辐射亮度水平。一般来说，不使用灯光主动捕鱼的船只可能具有较低的辐射亮度水平。当船只接近海岸线时，应考虑例外情况。为了进一步探索船只夜间灯光如何发出不同的辐射亮度水平，VIIRS活动图层可以过滤到与不同人类行为相关的特定兴趣范围。<br/>\n<br/>\n使用夜间灯光探测数据的人应考虑南大西洋异常区（SAA），这是地球内范艾伦辐射带海拔最低的区域，允许更多来自太空的高能粒子穿透。当这些粒子撞击卫星上的传感器时，可能会产生错误信号，导致算法将其识别为船只探测。已经应用了过滤算法，但仍可能存在一些误识别。",
        schema: {
            speed: "速度",
            bearing: "方位角",
            matched: {
                keyword: "匹配状态",
                "enum": {
                    "true": "匹配",
                    "false": "未匹配"
                }
            },
            radiance: {
                keyword: "辐射亮度",
                "enum": {
                    "0": "0",
                    "10000": "10000"
                }
            },
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    unknown: "未知",
                    fishing: "渔船",
                    carrier: "运输船",
                    support: "支持船"
                }
            },
            qf_detect: {
                keyword: "检测质量标志",
                "enum": {
                    "1": "1",
                    "2": "2",
                    "3": "3",
                    "5": "5",
                    "7": "7",
                    "10": "10"
                }
            }
        }
    },
    "public-areas-to-be-avoided-1618836788619": {
        name: "货运船舶应避开区域",
        description: "岛屿周围25海里缓冲区，建议船舶改道"
    },
    "public-bathymetry-contour": {
        name: "水深等高线",
        description: "表示水深等高线的线和点的组合"
    },
    "public-belize-fishing-effort": {
        name: "伯利兹VMS",
        description: "船舶监控系统（VMS）数据由伯利兹公海渔业部门（BHSFU）提供。数据通过卫星使用伯利兹的船舶监控系统收集，并在三天后发布，包含船舶位置、速度、航向和移动信息。\n\n海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。\n\nVMS的数据广播方式与AIS不同，可能在完整性、准确性和质量方面给出不同的衡量标准。海洋渔业观察持续改进其在所有广播数据格式中的算法，以通过算法识别\"明显捕鱼活动\"。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。\n\n出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为明显而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，用户必须自行决定是否依赖。\n\n海洋渔业观察的捕鱼存在算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "方位角"
        }
    },
    "public-belize-fishing-vessels": {
        name: "伯利兹VMS（渔船）",
        description: "渔船（伯利兹VMS）",
        schema: {
            source: "来源"
        }
    },
    "public-belize-vessel-identity-fishing": {
        name: "伯利兹VMS",
        description: "船舶身份（伯利兹VMS）"
    },
    "public-belize-vessel-identity": {
        name: "伯利兹VMS",
        description: "船舶身份（伯利兹VMS）"
    },
    "public-bra-onyxsat-fishing-effort": {
        name: "巴西VMS",
        description: "海洋渔业观察使用船舶身份、类型、位置、速度、方向等数据，这些数据通过自动识别系统（AIS）广播，并通过卫星和地面接收器收集。AIS是为安全/避碰而开发的。海洋渔业观察分析从我们研究中确定为已知或可能的商业渔船收集的AIS数据，并应用捕捞存在算法，根据船舶速度和方向的变化来确定\"表观捕捞活动\"。该算法将这些船舶的每个AIS广播数据点分类为表观捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热图上。广播的AIS数据在完整性、准确性和质量方面可能有所不同。此外，卫星或地面接收器的数据收集可能会因缺失或不准确的数据而引入错误。海洋渔业观察的捕捞存在算法是通过数学方法识别\"表观捕捞活动\"的最佳努力。因此，可能有些捕捞活动未被海洋渔业观察识别为捕捞活动；相反，海洋渔业观察可能会显示实际未发生捕捞的表观捕捞活动。出于这些原因，海洋渔业观察将船舶捕捞活动的指定，包括\"捕捞活动\"一词的同义词，如\"捕捞\"或\"捕捞努力量\"，限定为\"表观\"而非确定的。任何和所有关于\"表观捕捞活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。海洋渔业观察正在采取措施确保捕捞活动指定尽可能准确。海洋渔业观察的捕捞存在算法使用观察员收集的实际捕捞事件数据进行开发和测试，并结合对船舶移动数据的专家分析，从而手动分类了数千个已知的捕捞事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕捞活动分类数据和自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "方位角",
            target_species: {
                keyword: "目标物种",
                "enum": {
                    "Sardinha-verdadeira e Bonito-listrado": "巴西沙丁鱼和鲣鱼",
                    Polvo: "章鱼",
                    "Caranguejo-vermelho": "西南大西洋红蟹",
                    "Sardinha-verdadeira e Anchova": "巴西沙丁鱼和鳀鱼",
                    "peixes diversos": "杂鱼类",
                    "Sardinha-laje": "大西洋圆腹鲱",
                    "Pescada-gó": "犬牙石首鱼",
                    "Piramutaba e peixes diversos": "拉劳鲶鱼和杂鱼类",
                    "Corvina; Pescadas; Castanha e Abrótea": "白口石首鱼；石首鱼类；阿根廷石首鱼；巴西鳕鱼",
                    "Fundo e Superfície": "底层和表层",
                    "permissionamento antigo; em processo de conversão": "旧许可；转换中",
                    "Tainhas; Anchova e Serras": "鲻鱼；鳀鱼；锯鳐",
                    "Garoupas; Cherne; Sirigado e outros peixes de fundo": "石斑鱼；黑石斑鱼；其他底层鱼类",
                    "Sardinha-verdadeira e Tainha": "巴西沙丁鱼和灰鲻鱼",
                    Lagostas: "龙虾",
                    "Espadarte - atuns e afins": "剑鱼；金枪鱼及类似鱼类",
                    "Camarão-rosa e peixes diversos": "粉红虾和杂鱼类",
                    "Pescada Amarela": "美洲犬牙石首鱼",
                    "Peixe-sapo": "安康鱼",
                    "Piramutaba; Dourada e Gurijuba": "拉劳鲶鱼；金鲷；鳃背海鲶",
                    Pargo: "红笛鲷",
                    Serras: "锯鳐",
                    "Cavala e Albacorinha": "刺鲅和黑鳍金枪鱼",
                    "Camarão-sete-barbas": "海螯虾",
                    "Bonito-listrado": "鲣鱼",
                    "camarões": "杂虾类",
                    "Abrótea; Galo e Merluza": "巴西鳕鱼；月鲹；阿根廷无须鳕",
                    "peixes demersais": "底层鱼类",
                    " Camarão-rosa": "粉红虾",
                    "Dourado - atuns e afins": "鬼头刀；金枪鱼及类似鱼类",
                    "Albacoras - atuns e afins": "金枪鱼及类似鱼类"
                }
            }
        }
    },
    "public-bra-onyxsat-fishing-vessels": {
        name: "巴西VMS（渔船）",
        description: "渔船（巴西VMS）",
        schema: {
            source: "来源",
            codMarinha: "海洋代码",
            fishingZone: "捕捞区域",
            targetSpecies: {
                keyword: "目标物种",
                "enum": {
                    "Sardinha-verdadeira e Bonito-listrado": "巴西沙丁鱼和鲣鱼",
                    Polvo: "章鱼",
                    "Caranguejo-vermelho": "西南大西洋红蟹",
                    "Sardinha-verdadeira e Anchova": "巴西沙丁鱼和鳀鱼",
                    "peixes diversos": "杂鱼类",
                    "Sardinha-laje": "大西洋圆腹鲱",
                    "Pescada-gó": "犬牙石首鱼",
                    "Piramutaba e peixes diversos": "拉劳鲶鱼和杂鱼类",
                    "Corvina; Pescadas; Castanha e Abrótea": "白口石首鱼；石首鱼类；阿根廷石首鱼；巴西鳕鱼",
                    "Fundo e Superfície": "底层和表层",
                    "permissionamento antigo; em processo de conversão": "旧许可；转换中",
                    "Tainhas; Anchova e Serras": "鲻鱼；鳀鱼；锯鳐",
                    "Garoupas; Cherne; Sirigado e outros peixes de fundo": "石斑鱼；黑石斑鱼；其他底层鱼类",
                    "Sardinha-verdadeira e Tainha": "巴西沙丁鱼和灰鲻鱼",
                    Lagostas: "龙虾",
                    "Espadarte - atuns e afins": "剑鱼；金枪鱼及类似鱼类",
                    "Camarão-rosa e peixes diversos": "粉红虾和杂鱼类",
                    "Pescada Amarela": "美洲犬牙石首鱼",
                    "Peixe-sapo": "安康鱼",
                    "Piramutaba; Dourada e Gurijuba": "拉劳鲶鱼；金鲷；鳃背海鲶",
                    Pargo: "红笛鲷",
                    Serras: "锯鳐",
                    "Cavala e Albacorinha": "刺鲅和黑鳍金枪鱼",
                    "Camarão-sete-barbas": "海螯虾",
                    "Bonito-listrado": "鲣鱼",
                    "camarões": "杂虾类",
                    "Abrótea; Galo e Merluza": "巴西鳕鱼；月鲹；阿根廷无须鳕",
                    "peixes demersais": "底层鱼类",
                    " Camarão-rosa": "粉红虾",
                    "Dourado - atuns e afins": "鬼头刀；金枪鱼及类似鱼类",
                    "Albacoras - atuns e afins": "金枪鱼及类似鱼类"
                }
            }
        }
    },
    "public-bra-onyxsat-vessel-identity-fishing": {
        name: "巴西VMS（渔船）",
        description: "渔船（巴西VMS）"
    },
    "public-brazil-opentuna-fishing-vessels": {
        name: "巴西开放金枪鱼VMS（渔船）",
        description: "巴西VMS数据集（公共）",
        schema: {
            source: "来源"
        }
    },
    "public-brazil-opentuna-presence": {
        name: "巴西开放金枪鱼VMS",
        description: "存在（巴西开放金枪鱼）"
    },
    "public-brazil-opentuna-vessel-identity-fishing": {
        name: "巴西开放金枪鱼VMS（渔船）",
        description: "巴西VMS数据集（公共）"
    },
    "public-cfc-exploration-areas-individual": {
        name: "CFC勘探区域",
        description: "富钴铁锰结壳（Cobalt-rich ferromanganese crusts，简称CFC）通常出现在海山、海丘和高原的顶部和边缘，深度在800米至2500多米之间。这些结壳含有钴、镍、锰和稀土元素。富钴铁锰结壳的采矿方法包括研磨并完全从宿主岩石上移除结壳——宿主岩石是海洋生物多样性的栖息地——然后将产生的矿浆输送到地表。对于富钴铁锰结壳，分配给每个承包商的勘探区域为3000平方公里，由150个区块组成。每个区块不超过20平方公里。",
        schema: {
            status: "状态",
            act_date: {
                keyword: "生效日期",
                "enum": {
                    "1447023600000": "1447023600000",
                    "1697752800000": "1697752800000"
                }
            },
            area_key: "区域关键字",
            blk_cell: "区块单元格",
            blk_orig: {
                keyword: "区块来源",
                "enum": {}
            },
            sub_area: "子区域",
            area_km_2: {
                keyword: "面积（平方公里）",
                "enum": {
                    "0.99879855": "0.99879855",
                    "20.0156525": "20.0156525"
                }
            },
            area_type: "区域类型",
            clst_orig: {
                keyword: "集群起源",
                "enum": {
                    "978303600000": "978303600000",
                    "999295200000": "999295200000"
                }
            },
            cluster_id: {
                keyword: "集群ID",
                "enum": {
                    NR: "未报告",
                    "KC-1": "KC-1",
                    "KC-2": "KC-2",
                    "KC-3": "KC-3",
                    "KC-4": "KC-4",
                    "KC-5": "KC-5",
                    "KC-6": "KC-6",
                    "KC-7": "KC-7",
                    "KC-8": "KC-8",
                    "KC-9": "KC-9",
                    NA: "不适用"
                }
            },
            blk_cell_id: {
                keyword: "区块单元ID",
                "enum": {}
            },
            contract_id: {
                keyword: "合同ID",
                "enum": {
                    KOREACRFC1: "韩国CRFC1",
                    COMRACRFC1: "COMRA CRFC1",
                    BrazilCRFC1: "巴西CRFC1",
                    JOGMECCRFC1: "JOGMEC CRFC1",
                    RUSMNRCRFC1: "俄罗斯自然资源部CRFC1"
                }
            }
        }
    },
    "public-cfc-reserved-areas-individual": {
        name: "CFC保留区域",
        description: "富钴铁锰结壳（Cobalt-rich ferromanganese crusts，简称CFC）通常出现在海山、海丘和高原的顶部和边缘，深度在800米至2500多米之间。这些结壳含有钴、镍、锰和稀土元素。富钴铁锰结壳的采矿方法包括研磨并完全从宿主岩石上移除结壳——宿主岩石是海洋生物多样性的栖息地——然后将产生的矿浆输送到地表。国际海底管理局（International Seabed Authority，简称ISA）下的保留区域是确保发展中国家未来能够获得深海矿产资源的关键机制。这些区域通常由发达国家在申请勘探权时提供。",
        schema: {
            status: "状态",
            act_date: {
                keyword: "生效日期",
                "enum": {
                    "1425942000000": "1425942000000"
                }
            },
            area_key: "区域关键字",
            blk_cell: "区块单元格",
            blk_orig: {
                keyword: "区块来源",
                "enum": {}
            },
            sub_area: "子区域",
            area_km_2: "面积（平方公里）",
            area_type: "区域类型",
            cluster_id: "集群ID",
            blk_cell_id: {
                keyword: "区块单元ID",
                "enum": {}
            },
            contract_id: {
                keyword: "合同ID",
                "enum": {
                    CRFCReserved: "CRFC保留"
                }
            }
        }
    },
    "public-chile-all-vessels": {
        name: "智利VMS（所有船舶）",
        description: "智利VMS数据集（公共）"
    },
    "public-chile-fishing-effort": {
        name: "智利VMS",
        description: "船舶监控系统（VMS）数据由智利政府渔业和水产养殖监管机构（SERNAPESCA）提供。可以过滤智利的VMS数据，以查找小型渔船（<18米）和工业渔船（>18米）。请注意，有些船只<18米，但由于它们注册捕获工业配额，因此被视为工业船只。SERNAPESCA还使用我们的地图来可视化和跟踪其船队的船只位置，包括参与水产养殖的船只。\n\n数据通过卫星和地面接收器使用智利的VMS收集，包含船舶身份、渔具类型、位置、速度、方向等信息。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察地图上显示前者。\n\nVMS的数据广播方式与AIS有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼存在算法（与AIS一样）是通过算法识别\"明显捕鱼活动\"的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。\n\n出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为\"明显\"而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。\n\n海洋渔业观察的捕鱼存在算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    chile_vms_small_fisheries: "小型渔业",
                    chile_vms_industry: "工业渔业"
                }
            },
            speed: "速度",
            bearing: "方位角"
        }
    },
    "public-chile-fishing-vessels": {
        name: "智利VMS（渔船）",
        description: "智利VMS数据集（公共）"
    },
    "public-chile-non-fishing-vessels": {
        name: "智利VMS（非渔船）",
        description: "智利VMS数据集（公共）"
    },
    "public-chile-presence": {
        name: "智利VMS",
        description: "船舶监控系统（VMS）数据由智利政府渔业和水产养殖监管机构（SERNAPESCA）提供。可以过滤智利的VMS数据，以查找小型渔船（<18米）和工业渔船（>18米）。请注意，有些船只<18米，但由于它们注册捕获工业配额，因此被视为工业船只。SERNAPESCA还使用我们的地图来可视化和跟踪其船队的船只位置，包括参与水产养殖的船只。\n\n数据通过卫星和地面接收器使用智利的VMS收集，包含船舶身份、渔具类型、位置、速度、方向等信息。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察地图上显示前者。\n\nVMS的数据广播方式与AIS有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼存在算法（与AIS一样）是通过算法识别\"明显捕鱼活动\"的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。\n\n出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为\"明显\"而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。\n\n海洋渔业观察的捕鱼存在算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    chile_vms_small_fisheries: "小型渔业",
                    chile_vms_industry: "工业渔业",
                    chile_vms_aquaculture: "智利水产养殖",
                    chile_vms_transport: "智利运输船"
                }
            },
            speed: "速度",
            bearing: "方位角"
        }
    },
    "public-chile-vessel-identity-fishing": {
        name: "智利VMS（渔船）",
        description: "智利VMS数据集（公共）"
    },
    "public-chile-vessel-identity-non-fishing": {
        name: "智利VMS（非渔船）",
        description: "智利VMS数据集（公共）"
    },
    "public-clarion-clipperton-zone-isa-claim-areas": {
        name: "克拉里昂-克利珀顿区ISA许可证区域",
        description: "该区域代表克拉里昂-克利珀顿区（CCZ）的累积和连续区域，这是东太平洋的一个区域，正被作为海底采矿目标，并由国际海底管理局管理。该区域包括计划用于勘探的索赔区、为发展中国家保留的区域以及为环境利益而保护的区域。该区域的主要目标资源是多金属结核。",
        schema: {
            type: "类型",
            label: "标签",
            contractor: "承包商"
        }
    },
    "public-cold-water-corals": {
        name: "冷水珊瑚",
        description: "缓冲距离约1公里"
    },
    "public-coral-reefs": {
        name: "珊瑚礁",
        description: "<h2>概述</h2>\n<ul>\n<li>暖水珊瑚礁分布在清澈的浅水区，是高度动态的生态系统，支持着生物多样性最丰富的海洋栖息地。该数据集展示了热带和亚热带地区珊瑚礁的全球分布。</li>\n<ul>\n<h2>数据来源</h2>\n<ul>\n <a href='https://data.unep-wcmc.org/datasets/1'>UNEP-WCMC, WorldFish Centre, WRI, TNC (2021). Global distribution of warm-water coral reefs, compiled from multiple sources including the Millennium Coral Reef Mapping Project. Version 4.1. Includes contributions from IMaRS-USF and IRD (2005), IMaRS-USF (2005) and Spalding et al. (2001). Cambridge (UK): UN Environment World Conservation Monitoring Centre. Data DOI: https://doi.org/10.34892/t2wk-5t34.</a></li>"
    },
    "public-costa-rica-fishing-effort": {
        name: "哥斯达黎加VMS",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过卫星使用厄瓜多尔的船舶监控系统收集，并在三天后发布，包含船舶位置、速度、航向和移动信息。\n\n海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。\n\nVMS的数据广播方式与AIS不同，可能在完整性、准确性和质量方面给出不同的衡量标准。海洋渔业观察持续改进其在所有广播数据格式中的算法，以通过算法识别\"明显捕鱼活动\"。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。\n\n出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为明显而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，用户必须自行决定是否依赖。\n\n海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    costarica_vms_industrial_longline: "哥斯达黎加工业延绳钓船队",
                    costarica_vms_atuneros: "哥斯达黎加金枪鱼船队",
                    costarica_vms_sardineros: "哥斯达黎加沙丁鱼船队"
                }
            },
            speed: "速度",
            bearing: "方位角"
        }
    },
    "public-costa-rica-fishing-vessels": {
        name: "哥斯达黎加VMS",
        description: "哥斯达黎加VMS数据集（公共）",
        schema: {
            source: "来源"
        }
    },
    "public-costa-rica-vessel-identity-vessels": {
        name: "哥斯达黎加VMS",
        description: "哥斯达黎加VMS数据集（公共）"
    },
    "public-dgg_sar_caribe_match_2019": {
        name: "带有AIS匹配船舶的SAR",
        description: "使用合成孔径雷达（SAR）识别并与使用自动识别系统（AIS）数据的船舶匹配的船舶。目前仅提供2019年数据。来源：Sentinel-1。"
    },
    "public-dgg_sar_caribe_not_match_2019": {
        name: "没有AIS匹配船舶的SAR",
        description: "使用合成孔径雷达（SAR）识别的船舶，与使用自动识别系统（AIS）数据记录的任何船舶没有已知匹配。目前仅提供2019年数据。来源：Sentinel-1。"
    },
    "public-ecuador-fishing-effort": {
        name: "厄瓜多尔VMS",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过卫星使用厄瓜多尔的船舶监控系统收集，并在三天后发布，包含船舶位置、速度、航向和移动信息。\n\n海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。\n\nVMS的数据广播方式与AIS不同，可能在完整性、准确性和质量方面给出不同的衡量标准。海洋渔业观察持续改进其在所有广播数据格式中的算法，以通过算法识别\"明显捕鱼活动\"。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。\n\n出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为明显而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，用户必须自行决定是否依赖。\n\n海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "方位角",
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    fishing: "渔船"
                }
            }
        }
    },
    "public-ecuador-fishing-vessels": {
        name: "厄瓜多尔VMS（渔船）",
        description: "厄瓜多尔VMS数据集（公共）",
        schema: {
            source: "来源"
        }
    },
    "public-ecuador-non-fishing-vessels": {
        name: "厄瓜多尔VMS（非渔船）",
        description: "厄瓜多尔VMS数据集（公共）",
        schema: {
            source: "来源"
        }
    },
    "public-ecuador-presence": {
        name: "厄瓜多尔VMS",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过卫星使用厄瓜多尔的船舶监控系统收集，并在三天后发布，包含船舶位置、速度、航向和移动信息。\n\n海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。\n\nVMS的数据广播方式与AIS不同，可能在完整性、准确性和质量方面给出不同的衡量标准。海洋渔业观察持续改进其在所有广播数据格式中的算法，以通过算法识别\"明显捕鱼活动\"。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。\n\n出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为明显而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，用户必须自行决定是否依赖。\n\n海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "方位角",
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    fishing: "渔船",
                    "international traffic": "国际交通",
                    "national traffic": "国内交通",
                    tug: "拖船",
                    boat: "小船",
                    auxiliary: "辅助船"
                }
            }
        }
    },
    "public-ecuador-vessel-identity-fishing": {
        name: "厄瓜多尔VMS（渔船）",
        description: "厄瓜多尔VMS（渔船）"
    },
    "public-ecuador-vessel-identity-non-fishing": {
        name: "厄瓜多尔VMS（非渔船）",
        description: "厄瓜多尔VMS（非渔船）"
    },
    "public-eez-areas": {
        name: "专属经济区",
        description: "专属经济区（EEZ）从一个国家的海岸延伸最多200海里。数据来源：佛兰德斯海洋研究所（2019）。海洋边界地理数据库：海洋边界和专属经济区（200海里），版本11。来源：marineregions.org。"
    },
    "public-eez-areas-12nm": {
        name: "专属经济区12海里",
        description: "领海是从沿海国家的基线（通常是平均低潮线）延伸最多12海里（22.2公里；13.8英里）的沿海水域带。领海（和EEZ）线通常从直线基线绘制，这些基线由每个沿海国家按照《联合国海洋法公约》规则定义，见第7条。基线内的水域被视为\"内水\"（见第8条）。引用：佛兰德斯海洋研究所（2023）。海洋边界地理数据库：领海（12海里），版本4。可在线获取：https://www.marineregions.org/。https://doi.org/10.14284/633"
    },
    "public-eez-boundaries": {
        name: "专属经济区边界",
        description: "EEZ边界以实线显示为\"200海里\"、\"条约\"、\"中线\"、\"联合制度\"、\"连接线\"、\"单方面主张（无争议）\"，以虚线显示为\"联合制度\"、\"未解决\"、\"未解决中线\"，基于\"LINE_TYPE\"字段。佛兰德斯海洋研究所（2019）。海洋边界地理数据库：海洋边界和专属经济区（200海里），版本11。来源：marineregions.org。有关此图层的更多详细元数据信息，请参阅<a href='https://globalfishingwatch.org/faqs/reference-layer-sources/' target='_blank' rel=noopener'>元数据信息</a>"
    },
    "public-eez-land": {
        name: "专属经济区",
        description: "佛兰德斯海洋研究所（2019）。海洋边界地理数据库：海洋边界和专属经济区（200海里），版本11。来源：marineregions.org"
    },
    "public-fao": {
        name: "粮农组织",
        description: "粮农组织统计用主要捕鱼区是任意划定的区域，其边界是与国际渔业机构协商确定的，考虑到各种因素，包括：（i）自然区域和海洋的自然划分；（ii）各种政府间公约和条约中已建立的相邻统计渔业机构的边界；（iii）现有的国家实践；（iv）国家边界；（v）经纬度网格系统；（vi）水生动物群的分布；以及（vii）资源分布和区域内的环境条件。"
    },
    "public-fao-areas-major-subareas": {
        name: "粮农组织区域（主要区域和次区域）",
        description: "粮农组织统计用主要捕鱼区是任意划定的区域，其边界是与国际渔业机构协商确定的。主要捕鱼区（内陆和海洋）按两位数字代码及其名称列出如下。要访问每个捕鱼区的地图和边界描述，请点击下面列表或显示19个主要海洋捕鱼区的地图中的相关项目。<a href='https://www.fao.org/fishery/en/area/search' target='_blank'>来源</a>。有关此图层的更多详细元数据信息，请参阅<a href='https://globalfishingwatch.org/faqs/reference-layer-sources/' target='_blank' rel=noopener'>元数据信息</a>"
    },
    "public-fao-major": {
        name: "粮农组织主要捕捞区域",
        description: "粮农组织统计用主要捕鱼区是任意划定的区域，其边界是与国际渔业机构协商确定的。主要捕鱼区（内陆和海洋）按两位数字代码及其名称列出如下。要访问每个捕鱼区的地图和边界描述，请点击下面列表或显示19个主要海洋捕鱼区的地图中的相关项目。<a href='https://www.fao.org/fishery/en/area/search' target='_blank'>来源</a>。有关此图层的更多详细元数据信息，请参阅<a href='https://globalfishingwatch.org/faqs/reference-layer-sources/' target='_blank' rel=noopener'>元数据信息</a>",
        schema: {
            FID: "要素ID",
            F_CODE: "功能代码"
        }
    },
    "public-fisheries-restricted-areas": {
        name: "渔业限制区域",
        description: "渔业限制区（FRA）是一个地理定义的区域，其中一些特定的捕鱼活动被暂时或永久禁止或限制，以改善特定种群以及栖息地和深海生态系统的开发模式和保护。在地中海和黑海，176万平方公里的海洋栖息地受到GFCM建立的10个FRA的保护。这包括一个大型深水FRA（173万平方公里），其中禁止在所有水深超过1000米的水域使用拖网和拖网，以保护深海底栖栖息地。该图层取自GFCM网站，但经过手动调整，以反映REC.GFCM/29/2005/1号文件中规定的FRA原始坐标。"
    },
    "public-fixed-infrastructure": {
        name: "固定基础设施（SAR、光学）",
        description: "<h2>概述</h2>\n<p>卫星合成孔径雷达（SAR）是一种星载雷达成像系统，可在任何天气条件下检测海上船舶和基础设施。卫星天线向地球表面发射微波脉冲，然后测量并整合散射回航天器的微波能量，形成“后向散射”图像。SAR图像包含关于水面上不同物体的丰富信息，如它们的大小、方向和纹理。SAR成像系统克服了大多数天气条件和光照水平的限制，包括由于微波的云穿透特性而不受云和雨的影响，以及由于雷达是“主动”传感器（它发射并记录自己的能量）而不受白天或黑暗的影响。SAR相对于其他一些“被动”卫星传感器（如光电成像，由基于卫星的相机记录地面物体反射/发射的阳光/红外辐射）具有优势。后一种方法可能会受到云层、雾霾、天气事件和高纬度地区季节性黑暗的影响。</p>\n<p>海洋渔业观察使用算法检测卫星图像中的“异常”或亮像素，然后使用机器学习模型排除船舶，并确定其属于已知基础设施类别的概率：风力基础设施、石油基础设施、其他基础设施和噪声。</p>\n<h2>应用场景</h2>\n<ul>\n  <li><b>海上领域感知</b></li>\n  <ul>\n    <li>基础设施位置可以支持海上领域感知，并帮助理解海上发生的其他活动。</li><li>基础设施数据支持海洋工业化评估，便于监测正在经历建设或新开发的区域</li>\n  </ul>\n  <li><b>船舶监控</b></li>\n  <ul>\n    <li>基础设施位置可用于分析与基础设施相关的船舶行为，包括基于船舶与石油和风力结构的互动对船舶进行分组。</li>\n    <li>船舶与基础设施之间的互动有助于量化支持海上工业活动所需的资源</li><li>可以分析基础设施对捕鱼的影响，包括吸引或阻止捕鱼。</li>\n  </ul>\n  <li><b>海洋保护区（MPA）和海洋空间规划</b></li>\n  <ul>\n    <li>在指定新保护区的规划阶段，了解现有基础设施的位置对于理解应将哪些利益相关者纳入咨询过程、理解潜在冲突以及确定容易实现的目标至关重要。</li>\n  </ul>\n  <li><b>环境影响</b></li>\n  <ul>\n    <li>基础设施位置可用于帮助检测海洋污染事件，并区分不同类型的污染事件（例如，来自船舶的污染与来自平台的污染）</li>\n  </ul>\n</ul>\n<h2>限制条件</h2>\n<ul>\n  <li>Sentinel-1 SAR数据不采样大部分公海区域。</li>\n  <ul>\n    <li>Sentinel-1不采样大部分公海区域。然而，绝大多数工业活动都靠近海岸。此外，离海岸越远，使用AIS的渔船越多（60-90%），远远超过所有渔船的平均值（约25%）。因此，对于世界上大多数地区，我们的检测数据辅以AIS将捕获全球海洋中绝大多数人类活动。</li>\n  </ul>\n  <li>噪声伪影可能产生误报。</li>\n  <li>我们不提供靠近海岸的船舶检测，因为很难准确绘制海岸线的起始位置。</li>\n  <ul>\n    <li>我们不对海岸1公里范围内的物体进行分类，因为海岸线模糊和岩石会导致误报。我们也不对北极和南极的大部分地区进行分类，那里的海冰会产生太多误报；然而，在这两个地区，船舶交通要么非常少（南极），要么在AIS普及率高的国家（北欧或北美北部国家）。大多数工业活动发生在离海岸数公里的地方，例如沿大陆架断裂带捕鱼、通过航道的海洋运输，以及带有中大型石油钻井平台和风力发电场的海上开发。此外，海岸1公里范围内的船舶活动大多来自小型船只，如游艇。</li>\n  </ul>\n  <li>基于SAR影像的船舶检测主要受图像分辨率限制（Sentinel-1 IW GRD产品的分辨率约为20米）。</li>\n  <ul>\n    <li>因此，我们会错过大多数长度在15米以下的船舶，尽管如果物体是强反射体（例如金属制成的船舶而非木材或玻璃纤维），即使小于一个像素也能被看到。对于较小的船舶（< 25米），检测还取决于风速和海洋状态，因为更粗糙的海面会产生更高的后向散射，难以将小目标与海杂波分离。相反，雷达入射角越高，检测概率越高，因为天线接收的背景后向散射越少。船舶相对于卫星天线的方向也很重要，与雷达视线垂直的船舶会有更大的后向散射截面，增加被检测到的概率。</li>\n  </ul>\n  <li>船舶长度估计受地面真值数据质量限制</li><ul>    <li>尽管我们只选择了高置信度的AIS-SAR匹配来构建训练数据，但我们发现一些AIS记录包含错误报告的长度。然而，这些错误只导致了一小部分不精确的训练标签，深度学习模型可以容纳训练数据中的一些噪声。</li></ul>\n  <li>并非所有地区都被平等覆盖</li>\n  <ul>\n    <li>我们的捕鱼分类在某些地区可能不太准确。在游艇和其他服务船流量大的地区，例如一些国家的城市附近以及挪威和冰岛的峡湾，这些较小的船只可能会被错误分类为渔船。相反，在所有活动未公开共享的地区，预计会有一些渔船被错误分类为非渔船。更重要的是，许多工业渔船的长度在10到20米之间，我们模型在这些长度范围内的准确性（称为\"召回率\"）会迅速下降。因此，工业渔船的总数可能远高于我们检测到的数量。由于我们的模型使用来自SAR的船舶长度，可能可以使用类似于Kroodsma等人（2022）的方法来估计缺失船舶的数量。未来的工作可以解决这一挑战。</li>\n    <li>我们的数据可能低估了某些地区的捕鱼浓度，在这些地区，我们看到船舶活动区域被Sentinel-1足迹边缘\"切断\"。我们错过了非常小的船只（例如大多数手工捕鱼船），它们不太可能携带AIS设备。算法改进可以捕获从海岸开始的第一公里，未来几年更多SAR卫星的加入（另外两颗ESA Sentinel-1卫星和NASA的NISAR任务）将允许我们更广泛地应用这种方法来构建此地图并捕获海上的所有活动。</li>\n  </ul>\n</ul>\n<h2>方法</h2>\n<h3>SAR影像</h3>\n<p>我们使用欧洲航天局（ESA）哥白尼Sentinel-1任务的SAR影像[1]。这些图像来自两颗卫星（S1A和S1B，直到2021年12月S1B停止运行，2022年起仅有S1A），它们以180度相位差在极地太阳同步轨道上运行。每颗卫星的重复周期为12天，因此在两颗卫星都运行期间，它们共同提供大约每6天一次的全球沿海水域测绘。然而，每个位置的图像数量根据任务优先级、纬度和相邻卫星轨道的重叠程度而有很大差异。空间覆盖范围也随时间变化[2]。我们的数据包括干涉宽幅（IW）模式下的双极化图像（VH和VV），分辨率约为20米。</p>\n<p>[1]\n  <a target=\"_blank\" href=\"https://sedas.satapps.org/wp-content/uploads/2015/07/Sentinel-1_User_Handbook.pdf\">\n    <span style=\"color:rgb(0, 0, 0);\">https://sedas.satapps.org/wp-content/uploads/2015/07/Sentinel-1_User_Handbook.pdf</span>\n  </a>\n</p>\n<p>[2]<a target=\"_blank\" href=\"https://sentinels.copernicus.eu/web/sentinel/missions/sentinel-1/observation-scenario\">\n    <span style=\"color:rgb(0, 0, 0);\"></span>\n    <span style=\"color:rgb(0, 0, 0);\">https://sentinels.copernicus.eu/web/sentinel/missions/sentinel-1/observation-scenario</span>\n  </a>\n</p>\n<h3>基于SAR的基础设施检测</h3>\n<p>使用SAR检测基础设施基于一种称为恒虚警率（CFAR）的算法，这是一种用于雷达图像异常检测的阈值算法。该算法旨在搜索与周围区域（海杂波）相比异常明亮的像素值（目标）。该方法基于局部背景（在窗口内）的像素值设置阈值，逐像素扫描整个图像。高于阈值的像素值构成异常，很可能是检测结果的样本。</p>\n<h3>基础设施分类</h3>\n<p>为了对每个检测到的海上基础设施进行分类，我们使用机器学习模型并设计了基于ConvNeXt架构的卷积神经网络。我们机器学习分类方法的一个新颖方面是结合了Sentinel-1的SAR影像和Sentinel-2的光学影像。从双波段SAR（VH和VV）和四波段光学（RGB和NIR）图像的六个月合成图像中，我们为每个检测到的固定基础设施提取了小瓦片，相应物体位于瓦片中心。单个模型输出包括指定类别的概率：风力基础设施、石油基础设施、其他基础设施和噪声。</p>\n<h3>过滤</h3>\n<p>海洋渔业观察对SAR检测结果进行了后处理，以减少噪声（误报）、移除船舶，并排除高纬度海冰区域。我们使用聚类方法识别随时间变化（50米半径内）的检测结果，这些结果可能是同一结构但其坐标略有不同，并为它们分配了聚类中最常见的预测标签。我们还为在一个时间步中缺失但在前一个和后一个时间步中检测到的固定结构填补了空白，并删除了仅在单个时间步中出现的检测结果。</p>\n<h2>资源、代码和其他说明</h2>\n<p>本研究中开发的所有用于SAR检测、机器学习模型和分析的代码都是开源的，可在\n  <a target=\"_blank\" href=\"https://github.com/GlobalFishingWatch/paper-industrial-activity\">\n    <span style=\"color:rgb(0, 0, 0);\">https://github.com/GlobalFishingWatch/paper-industrial-activity</span>\n  </a>.\n</p>\n<h2>数据源和引用</h2>\n<p>所有船舶和基础设施数据均可通过海洋渔业观察数据门户\n  <a target=\"_blank\" href=\"https://globalfishingwatch.org\">\n    <span style=\"color:rgb(0, 0, 0);\">https://globalfishingwatch.org</span>\n  </a>. 重现本研究的所有数据可从\n  <a target=\"_blank\" href=\"https://doi.org/10.5281/zenodo.8256932\">\n    <span style=\"color:rgb(0, 0, 0);\">https://doi.org/10.6084/m9.figshare.24309475 / https://doi.org/10.5281/zenodo.8256932</span>\n  </a>\n  （统计分析和图表）和\n  <a target=\"_blank\" href=\"https://doi.org/10.6084/m9.figshare.24309469\">\n<span style=\"color:rgb(0, 0, 0);\">https://doi.org/10.6084/m9.figshare.24309469</span>\n  </a>\n  /\n  <a target=\"_blank\" href=\"https://doi.org/10.5281/zenodo.8258124\">\n    <span style=\"color:rgb(0, 0, 0);\">https://doi.org/10.5281/zenodo.8258124</span>\n  </a>\n  （模型训练和评估）。\n</p>\n<h2>许可证</h2><p>仅非商业使用。本网站和服务仅根据CC BY-NC 4.0许可证用于非商业用途。如果您想将本网站和/或服务用于商业目的，请联系我们。</p>",
        schema: {
            label: {
                keyword: "标签",
                "enum": {
                    oil: "石油",
                    wind: "风力",
                    unknown: "未知"
                }
            }
        }
    },
    "public-fixed-infrastructure-filtered-v1.1": {
        name: "海上固定基础设施（SAR、光学）",
        description: "<h2>概述</h2> <p>海上固定基础设施是一个全球数据集，使用人工智能和机器学习来检测和分类世界各地海洋中的结构。</p> <p>提供了分类标签（石油、风力和未知）以及反映我们对分配标签确定性的置信度水平（高、中或低）。可以使用标签和置信度水平在地图上过滤和着色检测结果。数据每月更新一次，每月初添加新的分类检测结果。使用时间条查看变化很简单，任何人都可以识别世界海洋的快速工业化。例如，您可以轻松观察到中国东海和北海的风电场扩张，或墨西哥湾或波斯湾石油基础设施的变化。</p> <p>通过叠加现有地图图层，您可以探索船舶如何与石油和风力结构相互作用，可视化合成孔径雷达（SAR）和可见红外成像辐射仪套件（VIIRS）船舶检测在基础设施周围的密度，或确定哪些海洋保护区（MPA）包含风力、石油或其他基础设施类型。这些只是我们现在可以提出的问题类型的例子。海上固定基础设施是同类中的第一个数据集，它不仅揭示了我们海洋的广泛工业化，还使各个行业的用户能够在研究、监测和管理中使用这些信息。</p> <h2>应用场景</h2> <ul> <li>海上领域感知</li> <ul> <li>基础设施位置可以支持海上领域感知，并帮助理解海上发生的其他活动。</li><li>基础设施数据支持海洋工业化评估，便于监测正在经历建设或新开发的区域</li> </ul> <li>船舶监控</li> <ul> <li>基础设施位置可用于分析与基础设施相关的船舶行为，包括基于船舶与石油和风力结构的互动对船舶进行分组。</li> <li>船舶与基础设施之间的互动有助于量化支持海上工业活动所需的资源</li> <li>可以分析基础设施对捕鱼的影响，包括吸引或阻止捕鱼。</li> </ul> <li>海洋保护区（MPA）和海洋空间规划</li> <ul> <li>在指定新保护区的规划阶段，了解现有基础设施的位置对于理解应将哪些利益相关者纳入咨询过程、理解潜在冲突以及确定容易实现的目标至关重要。</li> </ul> <li>环境影响</li> <ul> <li>基础设施位置可用于帮助检测海洋污染事件，并区分不同类型的污染事件（例如，来自船舶的污染与来自平台的污染）</li> </ul> </ul> <h2>注意事项</h2> <ul> <li><strong>Sentinel-1和Sentinel-2卫星不采样大部分公海区域。</strong></li> <ul> <li>大多数工业活动发生在相对靠近海岸的地方。</li> <li>SAR采集的范围和频率由任务优先级决定。</li> <li>更多信息请参阅：https://www.nature.com/articles/s41586-023-06825-8/figures/5</li> </ul> <li><strong>我们不提供海岸1公里范围内的基础设施检测</strong></li> <ul> <li>我们不对海岸1公里范围内的物体进行分类，因为很难确定海岸线的起始位置，模糊的海岸线和岩石会导致误报。</li> <li>大部分工业活动，包括带有中大型石油钻井平台和风力发电场的海上开发，发生在距离海岸数公里的地方。</li> </ul> <li> <strong>噪声伪影可能产生误报。</strong> </li> <ul> <li>岩石、小岛、海冰、雷达模糊（雷达回波）和图像伪影都可能导致误报</li> <li>包括智利南部、北极和挪威海在内的一些地区的检测结果已被过滤以去除噪声。</li> </ul> <li><strong>空间覆盖范围随时间变化，可能导致每年的检测结果不同 - <a target=\"_blank\" href=\"https://share.cleanshot.com/yG0qfF\"> <span style=\"color:rgb(0, 0, 0);\">示例</span> </a></strong> </li> <ul> <li>提供2017-01-01至近实时的基础设施检测数据，并每月更新。</li> </ul> <li> <strong>标签可能随时间变化</strong> </li> <ul> <li>分配给结构的标签是随时间平均的最大预测标签。随着我们获得更多数据，标签可能会变化，并更准确地预测真实的基础设施类型。</li> </ul> <li><strong>全球数据集并非完美无缺</strong></li> <ul> <li>我们已尽最大努力创建尽可能准确的产品，但仍可能存在未检测到或分类错误的基础设施。这在项目层面工作时最为明显。</li> <li>我们强烈鼓励用户向研究团队提供反馈，以便我们改进模型的未来版本。所有反馈都将受到高度重视。</li> </ul> </ul> <h2>方法</h2> <h3>SAR影像</h3> <p>我们使用欧洲航天局（ESA）哥白尼Sentinel-1任务的SAR影像[1]。这些图像来自两颗卫星（S1A和S1B，直到2021年12月S1B停止运行，2022年起仅有S1A），它们以180度相位差在极地太阳同步轨道上运行。每颗卫星的重复周期为12天，因此在两颗卫星都运行期间，它们共同提供大约每6天一次的全球沿海水域测绘。然而，每个位置的图像数量根据任务优先级、纬度和相邻卫星轨道的重叠程度而有很大差异。空间覆盖范围也随时间变化[2]。我们的数据包括干涉宽幅（IW）模式下的双极化图像（VH和VV），分辨率约为20米。</p> <p>[1] <a target=\"_blank\" href=\"https://sedas.satapps.org/wp-content/uploads/2015/07/Sentinel-1_User_Handbook.pdf\"> <span style=\"color:rgb(0, 0, 0);\">https://sedas.satapps.org/wp-content/uploads/2015/07/Sentinel-1_User_Handbook.pdf</span> </a> </p> <p>[2]<a target=\"_blank\" href=\"https://sentinels.copernicus.eu/web/sentinel/missions/sentinel-1/observation-scenario\"> <span style=\"color:rgb(0, 0, 0);\"></span> <span style=\"color:rgb(0, 0, 0);\">https://sentinels.copernicus.eu/web/sentinel/missions/sentinel-1/observation-scenario</span> </a> </p> <h3>SAR基础设施检测</h3> <p>使用SAR检测基础设施基于广泛使用的恒虚警率（CFAR）算法，这是一种专为在合成孔径雷达图像中检测船舶而设计的异常检测方法，已被修改以移除非静止物体。该算法旨在搜索与周围区域（海杂波）相比异常明亮的像素值（目标）。该方法基于局部背景（在窗口内）的像素值设置阈值，逐像素扫描整个图像。高于阈值的像素值构成异常，很可能是目标的样本。</p> <h3>基础设施分类</h3> <p>为了对每个检测到的海上基础设施进行分类，我们使用了深度学习，并设计了一个基于ConvNeXt架构的卷积神经网络。我们深度学习分类方法的一个新颖方面是将Sentinel-1的SAR影像与Sentinel-2的光学影像相结合。从双波段SAR（VH和VV）和四波段光学（RGB和NIR）图像的六个月合成图像中，我们为每个检测到的固定基础设施提取了小瓦片，相应物体位于瓦片中心。单个模型输出包括指定类别的概率：风力、石油、未知、马拉开波湖和噪声。</p> <h3>过滤</h3> <p>海洋渔业观察对分类后的SAR检测结果进行了后处理，以减少噪声（误报）、移除船舶、排除高纬度海冰区域，并纳入专家反馈。我们使用聚类方法来识别随时间变化（在50米半径内）可能是同一结构但其坐标略有不同的检测结果，并为它们分配聚类中最大的平均预测标签。我们还为在一个时间步中缺失但在前一个和后一个时间步中检测到的固定结构填补了空白，并删除了仅在单个时间步中出现的检测结果。最后，数据集经过了研究人员和行业专家的广泛人工审查和编辑，以完善最终产品，并提供尽可能准确的数据集。</p> <h3>数据字段描述</h3> <p>每个检测结果都有一个唯一的个体标识符（<em>detection_id</em>）。分类中使用了六个月的图像合成，因此<em>detection_date</em>代表六个月期间的中间日期。这有助于移除非静止物体（即船舶），并避免在结构正在建造或没有足够图像可用时模型产生混淆。<em>structure_id</em>允许您随时间跟踪一个结构。因此，每个<em>structure_id</em>对应多个<em>detection_id</em>（结构被检测到的每个月对应一个）。<em>wind</em>和<em>oil</em>标签分别代表任何与风力或石油相关的结构。<em>Unknown</em>代表与石油或风力无关的结构，如桥梁或导航浮标。</p> <p>每个结构都被分配了'高'、'中'和'低'的标签置信度级别，这些级别取决于检测结果相对于手动开发的风力和石油多边形边界的位置，以及标签与前一个月相比是否发生了变化。<em>label_confidence</em>字段可用于过滤分析。</p> <h2>资源、代码和其他说明</h2> <p>自动化过程中使用了两个代码仓库，两者都是私有的，不应公开共享。</p> <p>检测和分类：https://github.com/GlobalFishingWatch/sentinel-1-ee/tree/master</p> <p>聚类和重新分类：https://github.com/GlobalFishingWatch/infrastructure-post-processing</p> <p>为论文开发的所有代码，Paolo, F.S., Kroodsma, D., Raynor, J.等人，《卫星测绘揭示海上广泛的工业活动》，Nature 625, 85–91 (2024)，https://doi.org/10.1038/s41586-023-06825-8，包括SAR检测、深度学习模型和分析，都是开源的，可在https://github.com/GlobalFishingWatch/paper-industrial-activity免费获取。</p> <h2>源数据和引用</h2> <p>Copernicus Sentinel data 2017-current</p> <p>Lujala, Päivi; Jan Ketil Rød &amp; Nadia Thieme, 2007. 'Fighting over Oil: Introducing A New Dataset', Conflict Management and Peace Science 24(3), 239-256</p> <p>Sabbatino, M., Romeo, L., Baker, V., Bauer, J., Barkhurst, A., Bean, A., DiGiulio, J., Jones, K., Jones, T.J., Justman, D., Miller III, R., Rose, K., and Tong., A., Global Oil &amp; Gas Infrastructure Features Database Geocube Collection, 2019-03-25, https://edx.netl.doe.gov/dataset/global-oil-gas-infrastructure-features-database-geocube-collection, DOI: 10.18141/1502839</p> <h2>许可证</h2><p>仅非商业使用。本网站和服务仅根据CC BY-NC 4.0许可证用于非商业用途。如果您想将本网站和/或服务用于商业目的，请联系我们。</p> <h2>Global Fishing Watch元数据</h2> <p>基础设施开发方法应引用以下论文：</p> <p>Paolo, F.S., Kroodsma, D., Raynor, J.等人。《卫星测绘揭示海上广泛的工业活动》。Nature 625, 85–91 (2024)。https://doi.org/10.1038/s41586-023-06825-8</p> <p>为该论文开发的所有代码，包括SAR检测、深度学习模型和分析，都是开源的，可在https://github.com/GlobalFishingWatch/paper-industrial-activity免费获取。这些脚本生成和使用的所有数据可以引用以下数据仓库：</p> <p>分析和图表：https://doi.org/10.6084/m9.figshare.24309475</p> <p>训练和评估：https://doi.org/10.6084/m9.figshare.24309469</p>",
        schema: {
            label: {
                keyword: "标签",
                "enum": {
                    oil: "石油",
                    wind: "风力",
                    unknown: "未知"
                }
            },
            structure_id: "结构ID",
            label_confidence: {
                keyword: "置信度",
                "enum": {
                    high: "高",
                    low: "低",
                    medium: "中"
                }
            },
            structure_end_date: "结束日期",
            structure_start_date: "开始日期"
        }
    },
    "public-fixed-infrastructure-filtered": {
        name: "海上固定基础设施（SAR、光学）",
        description: "<h2>概述</h2> <p>海上固定基础设施是一个全球数据集，使用人工智能和机器学习来检测和分类世界各地海洋中的结构。</p> <p>提供了分类标签（石油、风力和未知）以及反映我们对分配标签确定性的置信度水平（高、中或低）。可以使用标签和置信度水平在地图上过滤和着色检测结果。数据每月更新一次，每月初添加新的分类检测结果。使用时间条查看变化很简单，任何人都可以识别世界海洋的快速工业化。例如，您可以轻松观察到中国东海和北海的风电场扩张，或墨西哥湾或波斯湾石油基础设施的变化。</p> <p>通过叠加现有地图图层，您可以探索船舶如何与石油和风力结构相互作用，可视化合成孔径雷达（SAR）和可见红外成像辐射仪套件（VIIRS）船舶检测在基础设施周围的密度，或确定哪些海洋保护区（MPA）包含风力、石油或其他基础设施类型。这些只是我们现在可以提出的问题类型的例子。海上固定基础设施是同类中的第一个数据集，它不仅揭示了我们海洋的广泛工业化，还使各个行业的用户能够在研究、监测和管理中使用这些信息。</p> <h2>应用场景</h2> <ul> <li>海上领域感知</li> <ul> <li>基础设施位置可以支持海上领域感知，并帮助理解海上发生的其他活动。</li><li>基础设施数据支持海洋工业化评估，便于监测正在经历建设或新开发的区域</li> </ul> <li>船舶监控</li> <ul> <li>基础设施位置可用于分析与基础设施相关的船舶行为，包括基于船舶与石油和风力结构的互动对船舶进行分组。</li> <li>船舶与基础设施之间的互动有助于量化支持海上工业活动所需的资源</li> <li>可以分析基础设施对捕鱼的影响，包括吸引或阻止捕鱼。</li> </ul> <li>海洋保护区（MPA）和海洋空间规划</li> <ul> <li>在指定新保护区的规划阶段，了解现有基础设施的位置对于理解应将哪些利益相关者纳入咨询过程、理解潜在冲突以及确定容易实现的目标至关重要。</li> </ul> <li>环境影响</li> <ul> <li>基础设施位置可用于帮助检测海洋污染事件，并区分不同类型的污染事件（例如，来自船舶的污染与来自平台的污染）</li> </ul> </ul> <h2>注意事项</h2> <ul> <li><strong>Sentinel-1和Sentinel-2卫星不采样大部分公海区域。</strong></li> <ul> <li>大多数工业活动发生在相对靠近海岸的地方。</li> <li>SAR采集的范围和频率由任务优先级决定。</li> <li>更多信息请参阅：https://www.nature.com/articles/s41586-023-06825-8/figures/5</li> </ul> <li><strong>我们不提供海岸1公里范围内的基础设施检测</strong></li> <ul> <li>我们不对海岸1公里范围内的物体进行分类，因为很难确定海岸线的起始位置，模糊的海岸线和岩石会导致误报。</li> <li>大部分工业活动，包括带有中大型石油钻井平台和风力发电场的海上开发，发生在距离海岸数公里的地方。</li> </ul> <li> <strong>噪声伪影可能产生误报。</strong> </li> <ul> <li>岩石、小岛、海冰、雷达模糊（雷达回波）和图像伪影都可能导致误报</li> <li>包括智利南部、北极和挪威海在内的一些地区的检测结果已被过滤以去除噪声。</li> </ul> <li><strong>空间覆盖范围随时间变化，可能导致每年的检测结果不同 - <a target=\"_blank\" href=\"https://share.cleanshot.com/yG0qfF\"> <span style=\"color:rgb(0, 0, 0);\">示例</span> </a></strong> </li> <ul> <li>提供2017-01-01至近实时的基础设施检测数据，并每月更新。</li> </ul> <li> <strong>标签可能随时间变化</strong> </li> <ul> <li>分配给结构的标签是随时间平均的最大预测标签。随着我们获得更多数据，标签可能会变化，并更准确地预测真实的基础设施类型。</li> </ul> <li><strong>全球数据集并非完美无缺</strong></li> <ul> <li>我们已尽最大努力创建尽可能准确的产品，但仍可能存在未检测到或分类错误的基础设施。这在项目层面工作时最为明显。</li> <li>我们强烈鼓励用户向研究团队提供反馈，以便我们改进模型的未来版本。所有反馈都将受到高度重视。</li> </ul> </ul> <h2>方法</h2> <h3>SAR影像</h3> <p>我们使用欧洲航天局（ESA）哥白尼Sentinel-1任务的SAR影像[1]。这些图像来自两颗卫星（S1A和S1B，直到2021年12月S1B停止运行，2022年起仅有S1A），它们以180度相位差在极地太阳同步轨道上运行。每颗卫星的重复周期为12天，因此在两颗卫星都运行期间，它们共同提供大约每6天一次的全球沿海水域测绘。然而，每个位置的图像数量根据任务优先级、纬度和相邻卫星轨道的重叠程度而有很大差异。空间覆盖范围也随时间变化[2]。我们的数据包括干涉宽幅（IW）模式下的双极化图像（VH和VV），分辨率约为20米。</p> <p>[1] <a target=\"_blank\" href=\"https://sedas.satapps.org/wp-content/uploads/2015/07/Sentinel-1_User_Handbook.pdf\"> <span style=\"color:rgb(0, 0, 0);\">https://sedas.satapps.org/wp-content/uploads/2015/07/Sentinel-1_User_Handbook.pdf</span> </a> </p> <p>[2]<a target=\"_blank\" href=\"https://sentinels.copernicus.eu/web/sentinel/missions/sentinel-1/observation-scenario\"> <span style=\"color:rgb(0, 0, 0);\"></span> <span style=\"color:rgb(0, 0, 0);\">https://sentinels.copernicus.eu/web/sentinel/missions/sentinel-1/observation-scenario</span> </a> </p> <h3>SAR基础设施检测</h3> <p>使用SAR检测基础设施基于广泛使用的恒虚警率（CFAR）算法，这是一种专为在合成孔径雷达图像中检测船舶而设计的异常检测方法，已被修改以移除非静止物体。该算法旨在搜索与周围区域（海杂波）相比异常明亮的像素值（目标）。该方法基于局部背景（在窗口内）的像素值设置阈值，逐像素扫描整个图像。高于阈值的像素值构成异常，很可能是目标的样本。</p> <h3>基础设施分类</h3> <p>为了对每个检测到的海上基础设施进行分类，我们使用了深度学习，并设计了一个基于ConvNeXt架构的卷积神经网络。我们深度学习分类方法的一个新颖方面是将Sentinel-1的SAR影像与Sentinel-2的光学影像相结合。从双波段SAR（VH和VV）和四波段光学（RGB和NIR）图像的六个月合成图像中，我们为每个检测到的固定基础设施提取了小瓦片，相应物体位于瓦片中心。单个模型输出包括指定类别的概率：风力、石油、未知、马拉开波湖和噪声。</p> <h3>过滤</h3> <p>海洋渔业观察对分类后的SAR检测结果进行了后处理，以减少噪声（误报）、移除船舶、排除高纬度海冰区域，并纳入专家反馈。我们使用聚类方法来识别随时间变化（在50米半径内）可能是同一结构但其坐标略有不同的检测结果，并为它们分配聚类中最大的平均预测标签。我们还为在一个时间步中缺失但在前一个和后一个时间步中检测到的固定结构填补了空白，并删除了仅在单个时间步中出现的检测结果。最后，数据集经过了研究人员和行业专家的广泛人工审查和编辑，以完善最终产品，并提供尽可能准确的数据集。</p> <h3>数据字段描述</h3> <p>每个检测结果都有一个唯一的个体标识符（<em>detection_id</em>）。分类中使用了六个月的图像合成，因此<em>detection_date</em>代表六个月期间的中间日期。这有助于移除非静止物体（即船舶），并避免在结构正在建造或没有足够图像可用时模型产生混淆。<em>structure_id</em>允许您随时间跟踪一个结构。因此，每个<em>structure_id</em>对应多个<em>detection_id</em>（结构被检测到的每个月对应一个）。<em>wind</em>和<em>oil</em>标签分别代表任何与风力或石油相关的结构。<em>Unknown</em>代表与石油或风力无关的结构，如桥梁或导航浮标。</p> <p>每个结构都被分配了'高'、'中'和'低'的标签置信度级别，这些级别取决于检测结果相对于手动开发的风力和石油多边形边界的位置，以及标签与前一个月相比是否发生了变化。<em>label_confidence</em>字段可用于过滤分析。</p> <h2>资源、代码和其他说明</h2> <p>自动化过程中使用了两个代码仓库，两者都是私有的，不应公开共享。</p> <p>检测和分类：https://github.com/GlobalFishingWatch/sentinel-1-ee/tree/master</p> <p>聚类和重新分类：https://github.com/GlobalFishingWatch/infrastructure-post-processing</p> <p>为论文开发的所有代码，Paolo, F.S., Kroodsma, D., Raynor, J.等人，《卫星测绘揭示海上广泛的工业活动》，Nature 625, 85–91 (2024)，https://doi.org/10.1038/s41586-023-06825-8，包括SAR检测、深度学习模型和分析，都是开源的，可在https://github.com/GlobalFishingWatch/paper-industrial-activity免费获取。</p> <h2>源数据和引用</h2> <p>Copernicus Sentinel data 2017-current</p> <p>Lujala, Päivi; Jan Ketil Rød &amp; Nadia Thieme, 2007. 'Fighting over Oil: Introducing A New Dataset', Conflict Management and Peace Science 24(3), 239-256</p> <p>Sabbatino, M., Romeo, L., Baker, V., Bauer, J., Barkhurst, A., Bean, A., DiGiulio, J., Jones, K., Jones, T.J., Justman, D., Miller III, R., Rose, K., and Tong., A., Global Oil &amp; Gas Infrastructure Features Database Geocube Collection, 2019-03-25, https://edx.netl.doe.gov/dataset/global-oil-gas-infrastructure-features-database-geocube-collection, DOI: 10.18141/1502839</p> <h2>许可证</h2> <p>仅非商业使用。本网站和服务仅根据CC BY-NC 4.0许可证用于非商业用途。如果您想将本网站和/或服务用于商业目的，请联系我们。</p> <h2>Global Fishing Watch元数据</h2> <p>基础设施开发方法应引用以下论文：</p> <p>Paolo, F.S., Kroodsma, D., Raynor, J.等人。《卫星测绘揭示海上广泛的工业活动》。Nature 625, 85–91 (2024)。https://doi.org/10.1038/s41586-023-06825-8</p> <p>为该论文开发的所有代码，包括SAR检测、深度学习模型和分析，都是开源的，可在https://github.com/GlobalFishingWatch/paper-industrial-activity免费获取。这些脚本生成和使用的所有数据可以引用以下数据仓库：</p> <p>分析和图表：https://doi.org/10.6084/m9.figshare.24309475</p> <p>训练和评估：https://doi.org/10.6084/m9.figshare.24309469</p>",
        schema: {
            label: {
                keyword: "标签",
                "enum": {
                    oil: "石油",
                    wind: "风力",
                    unknown: "未知"
                }
            },
            structure_id: "结构ID",
            label_confidence: {
                keyword: "标签置信度",
                "enum": {
                    high: "高",
                    low: "低",
                    medium: "中"
                }
            },
            structure_end_date: "结构结束日期",
            structure_start_date: "结构开始日期"
        }
    },
    "public-gfcm-fao": {
        name: "地中海渔业总委员会（GFCM）粮农组织（FAO）",
        description: "渔业限制区（FRA）是一个地理划定的区域，其中某些特定的捕捞活动被暂时或永久禁止或限制，以改善特定鱼类种群以及栖息地和深海生态系统的开发模式和保护。在地中海和黑海，176万平方公里的海洋栖息地受到GFCM设立的10个渔业限制区的保护。这包括一个大型深水渔业限制区（173万平方公里），其中禁止在所有水深超过1000米的水域使用拖网和拖曳网，以保护深海底栖生境。该图层取自GFCM网站，但经过手动调整，以反映REC. GFCM/29/2005/1号文件规定的渔业限制区原始坐标。"
    },
    "public-global-all-tracks": {
        name: "船舶轨迹",
        description: "该数据集包含所有船舶的轨迹（AIS）- 版本3.0",
        schema: {
            speed: {
                keyword: "速度",
                "enum": {
                    "0": "0",
                    "20": "20"
                }
            }
        }
    },
    "public-global-all-vessels": {
        name: "AIS（所有船舶）",
        description: "船舶自动识别系统（AIS）船舶",
        schema: {
            source: "来源"
        }
    },
    "public-global-bathymetry": {
        name: "水深",
        description: "<h2>概述</h2>\n<ul>\n<li>水深测量是对水深的测量，提供海底物理特征的详细信息。这个网格化的水深数据集是一个连续的全球地形模型，提供海洋的海拔数据（以米为单位），采用15弧秒间隔的网格。</li>\n <li>免责声明:\n地图上显示的水深图层基于GEBCO的网格化数据，代表每个瓦片的平均深度值，以米计算。这些瓦片的分辨率较粗，因此显示的深度可能与您点击的点的具体值不同。例如，如果您点击50米等值线内的船舶轨迹，由于分辨率差异，该点显示的深度可能与瓦片的平均值不完全匹配。\n请记住，水深数据集是概括性的，可能无法反映精细尺度上的精确海底条件。在将这些值用于监管或分析目的时，请谨慎解释。\n\n 如果您需要更精细的细节，您也可以上传自己的水深多边形进行更精确的分析。</li> \n\n <ul>\n<h2>来源</h2>\n<ul>\n <a href='https://www.gebco.net/data_and_products/gridded_bathymetry_data/#global'>GEBCO编译组（2023）GEBCO 2023网格（doi:10.5285/f98b053b-0cbc-6c23-e053-6c86abc0af7b）。</a></li>"
    },
    "public-global-carrier-vessels": {
        name: "AIS（运输船）",
        description: "船舶自动识别系统（AIS）运输船"
    },
    "public-global-chlorophyl-max": {
        name: "叶绿素a浓度-最大值",
        description: "叶绿素a是所有光合植物中发现的光捕获色素。 海洋浮游植物通过光合作用化学固定碳，吸收溶解的二氧化碳并产生氧气。 通过这一过程，海洋植物捕获的碳量与陆地植被光合作用捕获的碳量相当。 浮游植物数量的变化表明海洋生产力的变化，并为全球气候变化监测提供了关键的海洋联系。<br/>\n<br/>\n海洋中的叶绿素a浓度被用作浮游植物生物量的指标，因此是初级生产力模型的关键输入。 美国国家航空航天局（NASA）的Terra和Aqua卫星上的中等分辨率成像光谱仪（MODIS）每天测量海洋颜色，由此得出全球叶绿素a浓度。<br/>\n<br/>\n科学家们使用叶绿素来模拟地球的生物地球化学循环，如碳循环或氮循环。此外，在短时间尺度上，叶绿素可用于追踪海洋洋流、急流和羽流。MODIS数据的1公里分辨率和几乎每日的全球覆盖，使科学家能够观察沿海和河口环境中的中尺度海洋特征，这些特征在海洋科学研究中的重要性日益增加。<br/>\n<br/>\n<strong>来源</strong><br/>\n<br/>\n该3级产品包括在地球观测系统数据和信息系统（EOSDIS）下生成或收集的海洋颜色和卫星海洋生物学数据 - https://earthdata.nasa.gov/about。<br/>\n<br/>\n该数据集可用于研究沿海地区的生物学和水文学、沿海海洋栖息地多样性和地理分布的变化、生物地球化学通量及其对地球海洋和气候随时间的影响，以及气候和环境变异性和变化对海洋生态系统及其支持的生物多样性的最终影响。<br/>\n<br/>\n已应用缩放因子和偏移量。<br/>\n<br/>\n<strong>引用</strong><br/>\n<br/>\nNASA Goddard Space Flight Center, Ocean Ecology Laboratory, Ocean Biology Processing Group. Moderate-resolution Imaging Spectroradiometer (MODIS) Aqua Ocean Color Data, NASA OB.DAAC, Greenbelt, MD, USA.<br/>"
    },
    "public-global-chlorophyl-min": {
        name: "叶绿素a浓度-最小值",
        description: "叶绿素a是所有光合植物中发现的光捕获色素。海洋浮游植物通过光合作用化学固定碳，吸收溶解的二氧化碳并产生氧气。通过这一过程，海洋植物捕获的碳量与陆地植被光合作用捕获的碳量相当。浮游植物数量的变化表明海洋生产力的变化，并为全球气候变化监测提供了关键的海洋联系。<br/>\n<br/>\n海洋中的叶绿素a浓度被用作浮游植物生物量的指标，因此是初级生产力模型的关键输入。美国国家航空航天局（NASA）的Terra和Aqua卫星上的中等分辨率成像光谱仪（MODIS）每天测量海洋颜色，由此得出全球叶绿素a浓度。<br/>\n<br/>\n科学家们使用叶绿素来模拟地球的生物地球化学循环，如碳循环或氮循环。此外，在短时间尺度上，叶绿素可用于追踪海洋洋流、急流和羽流。MODIS数据的1公里分辨率和几乎每日的全球覆盖，使科学家能够观察沿海和河口环境中的中尺度海洋特征，这些特征在海洋科学研究中的重要性日益增加。<br/>\n<br/>\n<strong>来源</strong><br/>\n<br/>\n该3级产品包括在地球观测系统数据和信息系统（EOSDIS）下生成或收集的海洋颜色和卫星海洋生物学数据 - https://earthdata.nasa.gov/about。<br/>\n<br/>\n该数据集可用于研究沿海地区的生物学和水文学、沿海海洋栖息地多样性和地理分布的变化、生物地球化学通量及其对地球海洋和气候随时间的影响，以及气候和环境变异性和变化对海洋生态系统及其支持的生物多样性的最终影响。<br/>\n<br/>\n已应用缩放因子和偏移量。<br/>\n<br/>\n<strong>引用</strong><br/>\n<br/>\nNASA Goddard Space Flight Center, Ocean Ecology Laboratory, Ocean Biology Processing Group. Moderate-resolution Imaging Spectroradiometer (MODIS) Aqua Ocean Color Data, NASA OB.DAAC, Greenbelt, MD, USA.<br/>"
    },
    "public-global-chlorophyl": {
        name: "叶绿素a浓度",
        description: "<h2>概述</h2>\n<ul>\n<li>叶绿素a是所有光合植物中发现的光捕获色素。海洋浮游植物通过光合作用化学固定碳，吸收溶解的二氧化碳并产生氧气。该数据集包含全球海洋的生物地球化学参数，包括叶绿素，以1/4度水平分辨率显示。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://doi.org/10.48670/moi-00015'>使用欧盟哥白尼海洋服务信息生成；https://doi.org/10.48670/moi-00015。</a></li>"
    },
    "public-global-currents-uo": {
        name: "海流",
        description: "海流东向分量"
    },
    "public-global-currents-vo": {
        name: "海流",
        description: "海流向北分量"
    },
    "public-global-encounters-events-carriers-fishing": {
        name: "运输船-渔船相遇事件（AIS）",
        description: "从AIS数据中识别，当一艘运输船和一艘渔船在距离海岸锚地至少10公里处，在500米范围内停留至少2小时，且平均速度低于2节时的位置。"
    },
    "public-global-encounters-events": {
        name: "相遇事件（AIS）",
        description: "<h2>概述</h2> <h3> 相遇事件识别两艘船舶在海上似乎相遇的实例。 </h3> <ul> <p> 当检测到两艘船舶符合以下条件时，海洋渔业观察将其归类为相遇事件： </p> <li>彼此相距500米以内</li> <li>持续时间至少2小时</li> <li>平均速度低于2节</li> <li> 且距离海岸锚地至少10公里（5.4海里）。 </li> </ul> <ul> <p> 用户可以通过船舶特征和上下文过滤相遇事件，包括： </p> <li>相遇持续时间</li> <li> 船舶船旗 - 显示至少有一艘船舶悬挂所选国家船旗的相遇</li> <li> 相遇后的下一个港口访问 - 显示至少有一艘船舶访问了所选港口的相遇</li> <li>相遇中涉及的船舶类型</li> <li>用户保存的船舶组</li> </ul> <ul> <p>当前显示的相遇类型包括：</p> <li>运输船 ⇄ 加油船（实验性）</li> <li>运输船 ⇄ 渔船</li> <li>渔船 ⇄ 加油船（实验性）</li> <li>渔船 ⇄ 渔船（实验性）</li> <li>支持船 ⇄ 渔船</li> </ul> <p> 要查看特定相遇的更多详细信息（例如其位置或相遇船舶的身份），请点击与该事件关联的“查看更多”图标。 </p> <h2>注意事项</h2> <ul> <li> 海洋渔业观察事件是将基于规则的算法应用于AIS位置数据的结果。船舶在海上相遇可能有多种潜在原因。此类交互可能包括渔获物或补给品的转运、设备转移、船员更换、安全相关事项等。因此，相遇事件数据应被视为供审查的指标。 </li> <li> 不符合上述海洋渔业观察相遇事件规范的相遇不会包含在地图中，例如持续时间少于两小时的相遇和港口内相遇。 </li> <li> 同一两艘船舶在4小时窗口内发生的相遇会被合并为一个相遇事件。虽然在如此短的时间内发生多次相遇是可能的，但这种情况仍然极为罕见。 </li> <li> 500米接近阈值是使用推断位置而非原始AIS消息计算的。由于AIS传输间隔不规则，船舶位置通过使用报告的航向和速度的10分钟时间网格进行估计。然后基于这些估计位置计算接近度。由于这种建模方法，相遇中识别的船舶可能在整个2小时期间并未实际相距500米以内。 </li> <li> 船舶识别和渔具分类的偏差可能导致相遇事件的意外出现或缺失。船舶类型的错误分类可能由于船舶登记数据不一致或不完整而发生。当算法难以适当地对船舶进行分类时，也会发生错误分类，例如，当船舶使用多种渔具（从而改变其行为模式）或当一艘船舶的MMSI（海上移动服务识别码）号码被多艘船舶使用时。 </li> <li> 相遇事件位置可能与船舶航迹不完全对齐。海洋渔业观察通过计算事件内所有位置的平均纬度和经度，为每个事件确定一个单一位置。因此，在相遇事件期间，船舶可能从未占据过该精确位置。 </li> <li> 作为用户尽职调查过程的一部分，海洋渔业观察建议目视检查船舶航迹，始终参考额外的数据源和/或信息，并请求船舶记录以确认任何发现。 </li> </ul> <h2>了解更多</h2> <p> 您可以从我们的 <a href=\"http://globalfishingwatch.org/wp-content/uploads/GlobalViewOfTransshipment_Aug2017.pdf\" >报告</a > 或 <a href=\"https://www.frontiersin.org/articles/10.3389/fmars.2018.00240/full\" >科学出版物</a > 中了解更多关于转运行为的信息。 </p>",
        schema: {
            duration: {
                keyword: "持续时间",
                "enum": {
                    "2": "2",
                    "48": "48"
                }
            },
            next_port_id: "下一港口ID",
            encounter_type: {
                keyword: "相遇类型",
                "enum": {
                    "CARRIER-FISHING": "运输船 <> 渔船",
                    "SUPPORT-FISHING": "支持船 <> 渔船",
                    "FISHING-CARRIER": "渔船 <> 运输船",
                    "FISHING-BUNKER": "渔船 <> 加油船",
                    "FISHING-FISHING": "渔船 <> 渔船",
                    "CARRIER-BUNKER": "运输船 <> 加油船",
                    "FISHING-SUPPORT": "渔船 <> 支持船"
                }
            }
        }
    },
    "public-global-fishing-effort": {
        name: "AIS（自动识别系统）",
        description: "海洋渔业观察使用关于船只身份、类型、位置、速度、方向等的数据，这些数据通过自动识别系统（AIS）广播，并通过卫星和地面接收器收集。AIS是为安全/避碰而开发的。\n\n海洋渔业观察分析从我们研究中确定为已知或可能的商业渔船的船只收集的AIS数据，并应用捕鱼存在算法根据船只速度和方向的变化确定\"明显捕鱼活动\"。该算法将这些船只的每个AIS广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。\n\n广播的AIS数据在完整性、准确性和质量方面可能有所不同。此外，卫星或地面接收器收集的数据可能会通过缺失或不准确的数据引入错误。海洋渔业观察的捕鱼存在算法是通过数学方法识别\"明显捕鱼活动\"的最佳努力。因此，可能有些捕鱼活动未被海洋渔业观察识别为捕鱼活动；相反，海洋渔业观察可能会显示明显捕鱼活动而实际上并未发生捕鱼的情况。\n\n出于这些原因，海洋渔业观察将船只捕鱼活动的指定，包括\"捕鱼活动\"一词的同义词，如\"捕鱼\"或\"捕鱼努力\"，限定为\"明显\"而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。\n\n海洋渔业观察正在采取措施确保捕鱼活动指定尽可能准确。海洋渔业观察的捕鱼存在算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "方位角",
            distance_from_port_km: {
                keyword: "港口缓冲区",
                "enum": {
                    "0": "0",
                    "1": "1",
                    "2": "2",
                    "3": "3",
                    "4": "4",
                    "5": "5"
                }
            }
        }
    },
    "public-global-fishing-events": {
        name: "捕捞事件（AIS）",
        description: "该数据集包含AIS的捕鱼事件",
        schema: {
            type: {
                keyword: "类型",
                "enum": {
                    CARGO: "货船",
                    DISCREPANCY: "异常",
                    CARRIER: "运输船",
                    FISHING: "渔船",
                    GEAR: "渔具船",
                    OTHER: "其他",
                    PASSENGER: "客船",
                    SEISMIC_VESSEL: "物探船",
                    SUPPORT: "支持船"
                }
            }
        }
    },
    "public-global-fishing-vessels": {
        name: "AIS（渔船）",
        description: "AIS渔船",
        schema: {
            source: "来源"
        }
    },
    "public-global-gaps-events": {
        name: "AIS关闭事件",
        description: "该数据集包含AIS信号中断事件"
    },
    "public-global-loitering-events-carriers": {
        name: "运输船徘徊事件（AIS）",
        description: "该数据集包含AIS运输船徘徊事件"
    },
    "public-global-loitering-events": {
        name: "徘徊事件（AIS）",
        description: "<h2>概述</h2> <h3> 徘徊事件识别船舶远离海岸以低速运行的情况。徘徊事件突出显示船舶行为与潜在相遇事件一致（即静止或在海上缓慢漂流）但在AIS上看不到相遇船舶的情况。因此，这些不应被视为可能发生相遇事件的指标，而是可能发生未检测到的相遇的时间段。 </h3> <ul> <p>当满足以下条件时，海洋渔业观察将事件归类为徘徊事件：</p> <li>船舶位于距离海岸超过20海里（37.04公里）的位置，并且</li> <li>保持平均速度低于2节，</li> <li>持续时间至少1小时。</li> </ul> <h2>注意事项</h2> <ul> <li> 海洋渔业观察事件是将基于规则的算法应用于AIS位置数据的结果。如有可能，徘徊事件应与其他信息来源（如区域渔业管理组织的转运记录）进行交叉验证。 </li> <li> 徘徊事件中的船舶在事件发生时可能没有与任何其他船舶相遇。船舶在海上可能保持相对静止或缓慢移动的其他事件包括：维护、失去船舶动力、恶劣天气下怠速、在港口外等待停靠许可、正常捕鱼行为等。 </li> <li> 由于徘徊事件、捕鱼事件和相遇事件的定义不同，单个船舶移动模式可能触发多种事件类型。 </li> <li> 徘徊事件位置可能与船舶航迹不完全对齐。海洋渔业观察通过计算事件内所有位置的平均纬度和经度，为每个事件确定一个单一位置。因此，船舶在事件期间可能从未占据过该精确位置。 </li> <li> 作为用户尽职调查过程的一部分，海洋渔业观察建议目视检查船舶航迹，始终参考额外的数据源和/或信息，并请求船舶记录以确认任何发现。 </li> </ul> <h2>了解更多</h2> <p> 您可以通过查看 <a href=\"https://globalfishingwatch.org/data-documentation/apparent-fishing-events-ais/\" >表观捕鱼事件（AIS）数据文档中的AIS限制部分</a > 来了解使用AIS数据的注意事项。 </p>",
        schema: {
            type: {
                keyword: "船舶类型",
                "enum": {
                    CARGO: "货船",
                    DISCREPANCY: "异常",
                    CARRIER: "运输船",
                    FISHING: "渔船",
                    GEAR: "渔具船",
                    OTHER: "其他",
                    PASSENGER: "客船",
                    SEISMIC_VESSEL: "物探船",
                    SUPPORT: "支持船"
                }
            },
            duration: {
                keyword: "持续时间",
                "enum": {
                    "0": "0",
                    "48": "48"
                }
            },
            next_port_id: "下一港口ID"
        }
    },
    "public-global-nitrate": {
        name: "硝酸盐浓度（NO3）",
        description: "<h2>概述</h2>\n<ul>\n<li>硝酸盐是海洋植物光合作用所必需的，是海洋生产力的主要营养素，但高浓度可能是污染的指标。该数据集包含全球海洋的生物地球化学参数，包括硝酸盐，以1/4度水平分辨率显示。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://doi.org/10.48670/moi-00015'>使用欧盟哥白尼海洋服务信息生成；https://doi.org/10.48670/moi-00015。</a></li>\""
    },
    "public-global-other-vessels": {
        name: "AIS（其他船舶）",
        description: "来自AIS的其他船舶",
        schema: {
            source: "来源"
        }
    },
    "public-global-oxygen": {
        name: "氧气浓度（O2）",
        description: "<h2>概述</h2>\n<ul>\n<li>溶解氧是水中存在的氧气量，对海洋生物的生长和生存至关重要。海洋温度升高会导致低氧区扩大，这会影响海洋生物的分布和数量。该数据集包含全球海洋的生物地球化学参数，包括溶解氧，以1/4度水平分辨率显示。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://doi.org/10.48670/moi-00015'>使用欧盟哥白尼海洋服务信息生成；https://doi.org/10.48670/moi-00015。</a></li>"
    },
    "public-global-ph": {
        name: "氢离子浓度（PH）",
        description: "<h2>概述</h2>\n<ul>\n<li>海洋的酸度通过pH值来测量。二氧化碳吸收增加降低了海洋的pH值，导致海洋酸化，这可能对海洋生物产生广泛影响。该数据集包含全球海洋的生物地球化学参数，包括pH值，以1/4度水平分辨率显示。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://doi.org/10.48670/moi-00015'>使用欧盟哥白尼海洋服务信息生成；https://doi.org/10.48670/moi-00015。</a></li>"
    },
    "public-global-phosphate": {
        name: "磷酸盐浓度（PO4）",
        description: "<h2>概述</h2>\n<ul>\n<li>磷酸盐是海洋食物网和海洋生产力的主要营养素，但高浓度也可能是污染的指标。该数据集包含全球海洋的生物地球化学参数，包括磷酸盐，以1/4度水平分辨率显示。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://doi.org/10.48670/moi-00015'>使用欧盟哥白尼海洋服务信息生成；https://doi.org/10.48670/moi-00015。</a></li>"
    },
    "public-global-port-visits-events": {
        name: "港口访问事件（AIS）",
        description: "\n<h2>概述</h2>\n海洋渔业观察检测船舶进出港口的移动，并将其分类为四种不同的港口事件类型：\n<ul>\n  <li>港口进入</li>\n  <li>港口停留</li>\n  <li>港口间隙（在港口期间AIS传输的间隙）</li>\n  <li>港口离开</li>\n</ul>\n这些事件被分组形成港口访问事件，根据AIS活动模式表示船舶在港口的存在。\n在海洋渔业观察地图中，只显示了高置信度的港口访问。当检测到船舶有进港、停靠或缺口以及出港时，可以高度自信地确定港口访问。更具体地说：\n当AIS数据显示船只时，地图上会显示港口访问：\n<ul>\n  <li>在港口入口处锚地3公里范围内进入，</li>\n  <li>在已知港口出口4公里范围内退出，并且：</li>\n  <ul>\n    <li> 遇到端口间隙（即4小时或更长时间内没有AIS传输，这可能表明AIS在端口内关闭），或</li>\n    <li> 在港口停靠时，船只的速度降至0.2节以下，后来又增加到0.5节以上。 </li>\n  </ul>\n</ul>\n港口停靠站用于区分实际的港口访问和沿海过境。\n<h2>注意事项</h2>\n<ul>\n  <li>较低置信度的端口访问——通常是由噪声、稀疏或不完整的AIS传输引起的——目前被排除在地图之外。信心较低的港口访问虽然有时是合法的，但可能会错误地暗示没有发生的港口访问。</li>\n  <li> 正在进行的港口访问不会在地图上显示，因为根据定义，需要港口出口才能检测到高置信度的港口访问。</li>\n  <li> 此外，请注意，海洋渔业观察锚地数据集可能无法捕捉到所有实际锚地位置，这可能会导致港口事件的遗漏。有关锚固的完整列表，请参阅“了解更多”部分。</li>\n  <li>海洋渔业观察建议核实港口访问，始终参考其他数据源和/或信息，并要求船只提供记录以确认任何发现，作为用户尽职调查过程的一部分。 </li></ul>",
        schema: {
            type: {
                keyword: "船舶类型",
                "enum": {
                    CARGO: "货船",
                    DISCREPANCY: "异常",
                    CARRIER: "运输船",
                    FISHING: "渔船",
                    GEAR: "渔具船",
                    OTHER: "其他",
                    PASSENGER: "客船",
                    SEISMIC_VESSEL: "物探船",
                    SUPPORT: "支持船"
                }
            },
            duration: {
                keyword: "持续时间",
                "enum": {
                    "2": "2",
                    "48": "48"
                }
            }
        }
    },
    "public-global-ports-footprint": {
        name: "按港口ID划分的锚地凸包",
        description: "按港口ID分组使用凸包算法的锚地足迹",
        schema: {
            area: "面积",
            label: {
                keyword: "标签",
                "enum": {}
            },
            perimeter: "周长"
        }
    },
    "public-global-presence-tracks": {
        name: "船舶轨迹",
        description: "数据集包含所有船舶的航迹（AIS）- 版本20201001",
        schema: {
            speed: {
                keyword: "速度",
                "enum": {
                    "0": "0",
                    "20": "20"
                }
            }
        }
    },
    "public-global-presence": {
        name: "AIS",
        description: "海洋渔业观察使用通过自动识别系统（AIS）广播并通过卫星和地面接收器收集的船舶身份、类型、位置、速度、方向等数据。AIS系统最初是为安全/避碰目的开发的。活动图层显示船舶存在的热力图。船舶存在通过从船舶AIS传输的位置中每小时取一个位置来确定。",
        schema: {
            speed: {
                keyword: "速度",
                "enum": {
                    "<2": "<2",
                    "2-4": "2-4",
                    "4-6": "4-6",
                    "6-10": "6-10",
                    "10-15": "10-15",
                    "15-25": "15-25",
                    ">25": ">25"
                }
            },
            bearing: "航向"
        }
    },
    "public-global-salinity": {
        name: "盐度",
        description: "<h2>概述</h2>\n<ul>\n<li>海表盐度是对海洋表面盐浓度的测量。它与温度一起决定海水密度，是估算海洋对气候影响的关键参数。该数据集盐度以1/12度水平分辨率显示。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://doi.org/10.48670/moi-00016'>使用欧盟哥白尼海洋服务信息生成；https://doi.org/10.48670/moi-00016。</a></li>"
    },
    "public-global-sar-footprints": {
        name: "探测足迹",
        description: "检测足迹是平台在每次卫星扫描（或场景）中用于执行检测的区域。这些过滤器有助于保留相关检测并排除可能不准确的数据。<br/>\n<br/>\n检测足迹比整个场景小，因为它们排除了任何陆地区域和岛屿，并排除了场景边界500米的缓冲区和海岸线1公里的缓冲区。"
    },
    "public-global-sar-presence": {
        name: "雷达船舶探测（SAR）",
        description: "<h2>概述</h2>\n<p>卫星合成孔径雷达（SAR）是一种星载雷达成像系统，可以在任何天气条件下检测海上船舶和结构。微波脉冲由星载天线向地球表面发射。然后测量并整合散射回航天器的微波能量，形成“后向散射”图像。SAR图像包含有关水上不同物体的丰富信息，例如它们的大小、方向和纹理。由于微波的云层穿透特性，SAR成像系统可以克服大多数天气条件和光照水平，包括云层或降雨；由于雷达是一种“主动”传感器（它发射并记录自己的能量），因此也不受白天或黑夜的影响。SAR相对于其他“被动”卫星传感器（如电光成像）具有优势，后者由基于卫星的相机组成，记录物体反射的可见光/红外辐射。后一种方法可能会受到云层覆盖、雾霾、天气事件和高纬度地区季节性黑暗的影响。</p>\n<h2>使用案例</h2>\n<ul>\n <li>监测海洋保护区（MPA）、专属经济区（EEZ）、近岸禁区（IEZ）和区域渔业管理组织（RFMO）等感兴趣区域的船舶存在（包括捕鱼和非捕鱼）。</li>\n <li>评估在脆弱海洋生态系统和重要鱼类栖息地附近未出现在协作跟踪系统（包括自动识别系统（AIS）和船舶监控系统（VMS））上的船舶存在情况。</li>\n</ul>\n<h2>局限性</h2>\n<ul>\n <li><b>Sentinel-1 SAR数据不会对大部分公海进行采样。</b></li>\n <ul>\n <li>Sentinel-1不会对大部分公海进行采样。然而，绝大多数工业活动都靠近海岸。此外，距离海岸越远，使用AIS的渔船越多（60-90%），远高于所有渔船的平均水平。</li>\n </ul>\n <li><b>SAR图像分辨率限制了可检测的最小船舶尺寸。</b></li>\n <ul>\n <li>船舶的可检测性取决于多个因素，包括其尺寸、方向、速度和周围环境。Sentinel-1 SAR图像的分辨率约为10米，这意味着可可靠检测的最小船舶长度约为20米。</li>\n </ul>\n <li><b>图像获取频率低。</b></li>\n <ul>\n <li>Sentinel-1卫星对同一区域的重访周期约为6天。这意味着船舶可能在两次图像获取之间通过感兴趣区域，而不会被检测到。</li>\n </ul>\n <li><b>误报和漏报。</b></li>\n <ul>\n <li>尽管我们的检测算法经过了广泛测试，但仍可能出现误报（将非船舶物体识别为船舶）和漏报（未检测到实际船舶）。误报可能由多种因素引起，包括波浪、海冰、漂浮碎片或成像伪影。</li>\n </ul>\n</ul>",
        schema: {
            speed: "速度",
            bearing: "航向",
            matched: {
                keyword: "匹配AIS船舶",
                "enum": {
                    "true": "已匹配AIS",
                    "false": "未匹配AIS"
                }
            },
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    carrier: "运输船",
                    seismic_vessel: "物探船",
                    passenger: "客船",
                    other: "其他",
                    support: "支持船",
                    bunker: "加油船",
                    gear: "渔具船",
                    cargo: "货船",
                    fishing: "渔船",
                    discrepancy: "异常"
                }
            },
            neural_vessel_type: {
                keyword: "SAR船舶类型",
                "enum": {
                    "Likely non-fishing": "可能非捕捞",
                    "Likely Fishing": "可能捕捞",
                    Unknown: "未知"
                }
            }
        }
    },
    "public-global-sentinel2-footprints": {
        name: "探测足迹",
        description: "探测足迹"
    },
    "public-global-sentinel2-presence": {
        name: "光学影像船舶探测",
        description: "<h2>概述</h2>\n<p>该图层显示使用欧洲航天局Sentinel-2卫星收集的光学卫星影像检测到的船舶。光学影像类似于从太空拍摄的高质量航空摄影，使用可见光和近红外波长的反射阳光。这种类型的影像提供高分辨率细节，使我们能够发现小型船舶、识别尾流模式并更好地了解近岸活动。</p>\n<p>海洋渔业观察组织使用机器学习模型处理每张图像，根据尾流特征识别船舶并估计其长度、方向和速度。然后使用二级分类器过滤检测结果，移除非船舶物体，如云层、岩石或冰山。每个检测结果都链接到一个裁剪图像（缩略图），以便用户可以直观地检查模型识别的内容。</p>\n<p>由于光学卫星依赖阳光和晴朗天空，因此只有在白天且区域未被云层或雾霾遮蔽时才能进行检测。尽管存在这些局限性，光学影像检测在识别可能未出现在其他跟踪系统中的小型未跟踪船舶方面特别有帮助。</p>\n<h2>使用案例</h2>\n<ul>\n  <li>监测海洋保护区（MPA）、专属经济区（EEZ）、近岸禁区（IEZ）和区域渔业管理组织（RFMO）等感兴趣区域的船舶存在（包括捕鱼和非捕鱼）。在某些情况下，可以通过海底沉积物的扰动看到底拖网等活动。</li>\n  <li>评估在脆弱海洋生态系统和重要鱼类栖息地附近未出现在协作跟踪系统（包括自动识别系统（AIS）和船舶监控系统（VMS））上的船舶存在情况。</li>\n  <li>超越Sentinel-1 SAR和VIIRS等其他卫星遥感传感器的船舶检测，这些传感器仅检测物体的存在。光学影像提供有关船舶特征和行为的更详细信息。</li>\n</ul>",
        schema: {
            length: {
                keyword: "船舶长度",
                "enum": {
                    "<20": "<20",
                    "20-60": "20-60",
                    "60-100": "60-100",
                    ">100": ">100"
                }
            },
            bearing: "航向",
            matched: {
                keyword: "匹配状态",
                "enum": {
                    "true": "已匹配AIS",
                    "false": "未匹配AIS"
                }
            },
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    carrier: "运输船",
                    seismic_vessel: "物探船",
                    passenger: "客船",
                    other: "其他",
                    support: "支持船",
                    bunker: "加油船",
                    gear: "渔具船",
                    cargo: "货船",
                    fishing: "捕捞",
                    discrepancy: "不一致"
                }
            }
        }
    },
    "public-global-sst-anomalies-max": {
        name: "海表温度异常（最大值）",
        description: "海表温度异常（最大值）"
    },
    "public-global-sst-anomalies-min": {
        name: "海表温度异常（最小值）",
        description: "海表温度异常（最大值）"
    },
    "public-global-sst-anomalies": {
        name: "海表温度异常",
        description: "海表温度异常（平均值）"
    },
    "public-global-sst-max": {
        name: "表面温度最大值",
        description: "表面温度"
    },
    "public-global-sst-min": {
        name: "表面温度最小值",
        description: "表面温度"
    },
    "public-global-sst": {
        name: "海表温度",
        description: "<h2>概述</h2>\n<ul>\n<li>海表温度是指海水表面或接近表面的温度。它会影响天气和区域气候，与盐度一起可以驱动全球海洋环流和大规模洋流运动。该数据集提供了1/20度水平网格分辨率的海表温度，使用了来自红外和微波辐射计的原位和卫星数据。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://doi.org/10.48670/moi-00165'>使用欧盟哥白尼海洋服务信息生成；https://doi.org/10.48670/moi-00165。</a></li>"
    },
    "public-global-support-vessels": {
        name: "AIS（支持船）",
        description: "来自AIS的支持船",
        schema: {
            source: "来源"
        }
    },
    "public-global-thgt": {
        name: "波高",
        description: "<h2>概述</h2>\n<ul>\n<li>波高是指海面波浪从波谷（底部）到波峰（顶部）的垂直距离。该数据集使用有效波高，即给定采样期间内所有波高中最高三分之一的平均值。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://www.pacioos.hawaii.edu/metadata/ww3_global.html'>Cheung, K.F. 2010，更新于2021年。WaveWatch III（WW3）全球波浪模型。由太平洋岛屿海洋观测系统（PacIOOS）分发，该系统是美国综合海洋观测系统（IOOS®）的一部分，部分由美国国家海洋和大气管理局（NOAA）资助，奖项编号#NA16NOS0120024和#NA21NOS0120091。</a></li>"
    },
    "public-global-tracks": {
        name: "船舶轨迹",
        description: "该数据集包含所有船舶的航迹（AIS）- 版本3.0",
        schema: {
            speed: "速度"
        }
    },
    "public-global-vessel-identity": {
        name: "AIS（所有船舶类型）",
        description: "船舶身份（所有船舶类型）",
        schema: {
            registryTmtExtraFields: "船舶登记额外字段"
        }
    },
    "public-global-vessel-insights": {
        name: "AIS（洞察）",
        description: "AIS船舶洞察"
    },
    "public-global-viirs-presence": {
        name: "夜间灯光探测（VIIRS）",
        description: "夜间灯光船舶探测图层，又称可见红外成像辐射仪套件（VIIRS），显示卫星通过夜间船只发出的光线探测到的海上船只。虽然这一活动图层并不仅与渔船相关，但很可能显示与鱿鱼捕捞等活动相关的船只，这些船只使用明亮的灯光在夜间作业。<br/>\n<br/>基于Suomi NPP卫星，VIIRS传感器每晚至少扫描整个地球一次，探测灯光以提供全球至少一次的每日观测。由于极地轨道卫星的轨道设计，靠近极地的地区每天会有更多次过境，而赤道地区每天只有一次过境。<br/> \n<br/>\n由于船只仅基于光发射被探测到，我们可以探测到可能不广播身份信息的单个船只甚至整个捕鱼船队，因此这些船只可能不会在海洋渔业观察地图上的其他地方显示. Global Fishing Watch ingests boat detections processed from low light imaging data collected by the U.S. National Oceanic and Atmospheric Administration (NOAA) VIIRS. The boat detections are processed in near-real time by the <a href='https://eogdata.mines.edu/products/vbd/' target='_blank' rel=noopener'>Earth Observation Group</a> at the Colorado School of Mines. The data, known as VIIRS boat detections, picks up the presence of vessels, including those fishing using lights to attract catch or to conduct operations at night.Lights from fixed offshore infrastructure and other non-vessel sources are excluded. Read more about VIIRS night light vessel detections, and download the <a href='https://eogdata.mines.edu/products/vbd/' target='_blank' rel=noopener'>data</a>.<br/>\n<br/>\n海洋渔业观察开发了一套复杂的系统 to match available automatic identification system (AIS) data to respective night light vessel detections. This matching is done using a probabilistic model that determines AIS-message/VIIRS-detection pairs based on all available AIS records right before and right after the time the satellite VIIRS image was taken, as well as the probability of pairing a specific AIS message to any of the vessels appearing on that image. Using this information, Global Fishing Watch has added the experimental ability to filter detections based on vessel type and gear type within the VIIRS activity layer.<br/>\n<br/>\nMore than 85% of the detections are from vessels that lack AIS or publicly shared vessel monitoring system (VMS) transponders. The global addition of the VIIRS layer enables you to rapidly filter the night light detections that either were matched or not with AIS where vessel identification is available.<br/>\n<br/>\nRadiance indicates the brightness of the light source received by the VIIRS sensor. Radiance is impacted by the moon, clouds, and the angle of the vessel from the satellite. Two vessels with the same brightness, or light intensity, may have different radiance levels depending on the conditions. In general, vessels that are not actively fishing using light may have lower radiance levels. Exceptions should be considered when vessels are approaching a coastline. To further explore how vessel lights at night emit different radiance levels, the VIIRS activity layer can be filtered to specific ranges of interest associated with different human behaviours.<br/>\n<br/>\nThose using night light detections data should consider the South Atlantic Anomaly (SAA), an area where the Earth's inner Van Allen radiation belt is at its lowest altitude, allowing more energetic particles from space to penetrate. When such particles hit the sensors on a satellite, this can create a false signal which might cause the algorithm to recognize it as a boat detection. A filtration algorithm has been applied but there may still be some mis-identification",
        schema: {
            speed: "速度",
            bearing: "航向",
            matched: {
                keyword: "匹配状态",
                "enum": {
                    "true": "已匹配AIS",
                    "false": "未匹配AIS"
                }
            },
            radiance: {
                keyword: "辐射亮度",
                "enum": {
                    "0": "0",
                    "10000": "10000"
                }
            },
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    unknown: "未知",
                    fishing: "渔船",
                    carrier: "运输船",
                    support: "支持船"
                }
            },
            qf_detect: {
                keyword: "检测质量标志",
                "enum": {
                    "1": "1",
                    "2": "2",
                    "3": "3",
                    "5": "5",
                    "7": "7",
                    "10": "10"
                }
            }
        }
    },
    "public-global-water-salinity-max": {
        name: "盐度",
        description: "海表盐度是估计海洋对气候影响的关键参数。与温度一起，盐度是决定海水密度的关键因素，从而决定水团的对流和再出露。<br/>\n<br/>\n全球环流在温度和盐度的驱动下，在表层和深层穿越所有海洋。全球“传送带”是大规模环流的简单模型，称为“温盐”环流。深水在北大西洋形成，下沉，向南移动，围绕南极洲循环，最终进入印度洋、太平洋和大西洋盆地。洋流将冷水团从北带到南，反之亦然。<br/>\n<br/>\n这种温盐环流极大地影响了世界两极海冰的形成，承载着海洋食物来源和海洋生物环绕地球，同时影响降雨模式、风模式、飓风和季风。<br/>\n<br/>\n<strong>来源</strong><br/>\n<br/>\n混合坐标海洋模型（HYCOM）是一种数据同化混合等密度- sigma-压力（广义）坐标海洋模型。EE中托管的HYCOM数据子集包含盐度、温度、速度和海拔等变量。它们已被插值到80.48°S和80.48°N之间的统一0.08度经纬度网格上。盐度、温度和速度变量已被插值到40个标准z级。<br/>\n<br/>\nHYCOM联盟，包括国家海洋合作计划（NOPP），是美国全球海洋数据同化实验（GODAE）的一部分。<br/>\n<br/>\n由国家海洋合作计划、海军研究办公室（ONR）和国防部高性能计算现代化计划资助。<br/>\n<br/>\n<strong>引用</strong><br/>\n<br/>\nJ. A. Cummings和O. M. Smedstad。2013年：全球海洋的变分数据同化。大气、海洋和水文应用的数据同化第二卷，第13章，303-343页。"
    },
    "public-global-water-salinity-min": {
        name: "盐度",
        description: "海表盐度是估计海洋对气候影响的关键参数。与温度一起，盐度是决定海水密度的关键因素，从而决定水团的对流和再出露。<br/>\n<br/>\n全球环流在温度和盐度的驱动下，在表层和深层穿越所有海洋。全球“传送带”是大规模环流的简单模型，称为“温盐”环流。深水在北大西洋形成，下沉，向南移动，围绕南极洲循环，最终进入印度洋、太平洋和大西洋盆地。洋流将冷水团从北带到南，反之亦然。<br/>\n<br/>\n这种温盐环流极大地影响了世界两极海冰的形成，承载着海洋食物来源和海洋生物环绕地球，同时影响降雨模式、风模式、飓风和季风。<br/>\n<br/>\n<strong>来源</strong><br/>\n<br/>\n混合坐标海洋模型（HYCOM）是一种数据同化混合等密度- sigma-压力（广义）坐标海洋模型。EE中托管的HYCOM数据子集包含盐度、温度、速度和海拔等变量。它们已被插值到80.48°S和80.48°N之间的统一0.08度经纬度网格上。盐度、温度和速度变量已被插值到40个标准z级。<br/>\n<br/>\nHYCOM联盟，包括国家海洋合作计划（NOPP），是美国全球海洋数据同化实验（GODAE）的一部分。<br/>\n<br/>\n由国家海洋合作计划、海军研究办公室（ONR）和国防部高性能计算现代化计划资助。<br/>\n<br/>\n<strong>引用</strong><br/>\n<br/>\nJ. A. Cummings和O. M. Smedstad。2013年：全球海洋的变分数据同化。大气、海洋和水文应用的数据同化第二卷，第13章，303-343页。"
    },
    "public-global-water-salinity": {
        name: "盐度",
        description: "海表盐度是估计海洋对气候影响的关键参数。与温度一起，盐度是决定海水密度的关键因素，从而决定水团的对流和再出露。<br/>\n<br/>\n全球环流在温度和盐度的驱动下，在表层和深层穿越所有海洋。全球“传送带”是大规模环流的简单模型，称为“温盐”环流。深水在北大西洋形成，下沉，向南移动，围绕南极洲循环，最终进入印度洋、太平洋和大西洋盆地。洋流将冷水团从北带到南，反之亦然。<br/>\n<br/>\n这种温盐环流极大地影响了世界两极海冰的形成，承载着海洋食物来源和海洋生物环绕地球，同时影响降雨模式、风模式、飓风和季风。<br/>\n<br/>\n<strong>来源</strong><br/>\n<br/>\n混合坐标海洋模型（HYCOM）是一种数据同化混合等密度- sigma-压力（广义）坐标海洋模型。EE中托管的HYCOM数据子集包含盐度、温度、速度和海拔等变量。它们已被插值到80.48°S和80.48°N之间的统一0.08度经纬度网格上。盐度、温度和速度变量已被插值到40个标准z级。<br/>\n<br/>\nHYCOM联盟，包括国家海洋合作计划（NOPP），是美国全球海洋数据同化实验（GODAE）的一部分。<br/>\n<br/>\n由国家海洋合作计划、海军研究办公室（ONR）和国防部高性能计算现代化计划资助。<br/>\n<br/>\n<strong>引用</strong><br/>\n<br/>\nJ. A. Cummings和O. M. Smedstad。2013年：全球海洋的变分数据同化。大气、海洋和水文应用的数据同化第二卷，第13章，303-343页。"
    },
    "public-global-water-temperature-max": {
        name: "海表温度",
        description: "海表温度是海洋表面或近表面的水温。海表温度影响天气和区域气候。温度和盐度驱动全球海洋环流和大规模洋流运动。<br/>\n<br/>\n<strong>来源</strong><br/>\n<br/>\n混合坐标海洋模型（HYCOM）是一种数据同化混合等密度- sigma-压力（广义）坐标海洋模型。EE中托管的HYCOM数据子集包含盐度、温度、速度和海拔等变量。它们已被插值到80.48°S和80.48°N之间的统一0.08度经纬度网格上。盐度、温度和速度变量已被插值到40个标准z级。<br/>\n<br/>\nHYCOM联盟，包括国家海洋合作计划（NOPP），是美国全球海洋数据同化实验（GODAE）的一部分。<br/>\n<br/>\n由国家海洋合作计划、海军研究办公室（ONR）和国防部高性能计算现代化计划资助。<br/>\n<br/>\n<strong>引用</strong><br/>\n<br/>\nJ. A. Cummings和O. M. Smedstad。2013年：全球海洋的变分数据同化。大气、海洋和水文应用的数据同化第二卷，第13章，303-343页。"
    },
    "public-global-water-temperature-min": {
        name: "海表温度",
        description: "海表温度是海洋表面或近表面的水温。海表温度影响天气和区域气候。温度和盐度驱动全球海洋环流和大规模洋流运动。<br/>\n<br/>\n<strong>来源</strong><br/>\n<br/>\n混合坐标海洋模型（HYCOM）是一种数据同化混合等密度- sigma-压力（广义）坐标海洋模型。EE中托管的HYCOM数据子集包含盐度、温度、速度和海拔等变量。它们已被插值到80.48°S和80.48°N之间的统一0.08度经纬度网格上。盐度、温度和速度变量已被插值到40个标准z级。<br/>\n<br/>\nHYCOM联盟，包括国家海洋合作计划（NOPP），是美国全球海洋数据同化实验（GODAE）的一部分。<br/>\n<br/>\n由国家海洋合作计划、海军研究办公室（ONR）和国防部高性能计算现代化计划资助。<br/>\n<br/>\n<strong>引用</strong><br/>\n<br/>\nJ. A. Cummings和O. M. Smedstad。2013年：全球海洋的变分数据同化。大气、海洋和水文应用的数据同化第二卷，第13章，303-343页。"
    },
    "public-global-water-temperature": {
        name: "海表温度",
        description: "海表温度是海洋表面或近表面的水温。海表温度影响天气和区域气候。温度和盐度驱动全球海洋环流和大规模洋流运动。<br/>\n<br/>\n<strong>来源</strong><br/>\n<br/>\n混合坐标海洋模型（HYCOM）是一种数据同化混合等密度- sigma-压力（广义）坐标海洋模型。EE中托管的HYCOM数据子集包含盐度、温度、速度和海拔等变量。它们已被插值到80.48°S和80.48°N之间的统一0.08度经纬度网格上。盐度、温度和速度变量已被插值到40个标准z级。<br/>\n<br/>\nHYCOM联盟，包括国家海洋合作计划（NOPP），是美国全球海洋数据同化实验（GODAE）的一部分。<br/>\n<br/>\n由国家海洋合作计划、海军研究办公室（ONR）和国防部高性能计算现代化计划资助。<br/>\n<br/>\n<strong>引用</strong><br/>\n<br/>\nJ. A. Cummings和O. M. Smedstad。2013年：全球海洋的变分数据同化。大气、海洋和水文应用的数据同化第二卷，第13章，303-343页。"
    },
    "public-global-winds-uo": {
        name: "风场",
        description: "东风分量"
    },
    "public-global-winds-vo": {
        name: "风场",
        description: "北风分量"
    },
    "public-graticules": {
        name: "经纬度网格",
        description: "根据地图缩放级别，以1°、5°、10°和30°间隔显示的纬度和经度网格或经纬网（来源：<a href='https://www.naturalearthdata.com/downloads/110m-physical-vectors/110m-graticules/'_blank'>Natural Earth</a>）。"
    },
    "public-gs-as-simplified": {
        name: "简化的地理渔业区域",
        description: "简化的地理渔业区域"
    },
    "public-gulf-of-lion-french-zones": {
        name: "法国狮子湾区域",
        description: "法国狮子湾区域"
    },
    "public-high-seas": {
        name: "公海",
        description: "公海是指专属经济区（EEZ）以外的任何海域。公海区是完全被专属经济区包围的区域。这些口袋区很难与周围的多个专属经济区管辖区区分开来，因此我们有一个图层来突出显示它们。有关此图层的更多详细元数据信息，请参阅<a href='https://globalfishingwatch. org/faqs/reference-layer-sources/' target='_blank' rel=noopener'>元数据信息</a>。"
    },
    "public-high-seas-pockets": {
        name: "公海区",
        description: "<p> 《联合国海洋法公约》将公海描述为 ‘不属于任何国家专属经济区、领海、内水或群岛国群岛水域的所有海域部分。’ 公海区是完全被专属经济区包围的区域。 这些口袋区很难与周围的多个专属经济区管辖区区分开来，因此我们有一个图层来突出显示它们。 引用：佛兰德斯海洋研究所（2024）。海洋边界地理数据库：公海，版本2。在线可访问：<a href=\"https://www.marineregions.org/\" target=\"_blank\" >https://www.marineregions.org/</a >。 </p>"
    },
    "public-indian-ocean-isa-claim-areas": {
        name: "印度洋ISA许可证区域",
        description: "该图层展示了印度洋国际海底管理局（ISA）海底采矿许可证区域，主要包含多金属硫化物和多金属结核。目前该区域的勘探租约由印度、德国、韩国和中国持有。",
        schema: {
            type: "类型",
            label: "标签",
            contractor: "承包商"
        }
    },
    "public-indonesia-fishing-effort": {
        name: "印度尼西亚VMS",
        description: "印度尼西亚的船舶监控系统（VMS）数据目前无法获取2020年7月以后的时期。\n\n船舶监控系统（VMS）数据由印度尼西亚政府海事和渔业部提供。数据通过卫星和地面接收器使用其VMS收集，包含船舶身份、渔具类型、位置、速度、方向等信息。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将这些船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。\n\nVMS的数据广播方式与AIS有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼存在算法（与AIS一样）是通过算法识别\"明显捕鱼活动\"的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为\"明显\"而非确定的。\n\n任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。海洋渔业观察的捕鱼存在算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，分享捕鱼活动分类数据和自动分类技术。"
    },
    "public-indonesia-fishing-vessels": {
        name: "印度尼西亚VMS（渔船）",
        description: "印度尼西亚船舶监控系统（VMS）公开数据集"
    },
    "public-indonesia-pelagic-fishing-effort": {
        name: "印度尼西亚中上层渔业（试点）",
        description: "印度尼西亚中上层渔业捕捞努力量公开数据"
    },
    "public-indonesia-pelagic-presence": {
        name: "印度尼西亚远洋中上层鱼类（试点）",
        description: "海洋渔业观察的这一图层使用由Rare、Aruna和AP2HI提供的数据。数据通过远洋设备收集，这些设备跟踪位置和速度。显示的信息代表船舶存在。存在状态通过每小时获取一次船舶跟踪设备传输的位置来确定。"
    },
    "public-indonesia-zebrax-presence": {
        name: "印度尼西亚Zebrax",
        description: "海洋渔业观察的这一图层使用由Rare、Aruna和AP2HI提供的数据。数据通过远洋设备收集，这些设备跟踪位置和速度。显示的信息代表船舶存在。存在状态通过每小时获取一次船舶跟踪设备传输的位置来确定。",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "public-inshore-fishing-zone-1618837176535": {
        name: "近岸渔业区",
        description: "特里斯坦群岛周围50海里和戈夫岛周围40海里（专属经济区的8%）"
    },
    "public-isa-areas-contractor": {
        name: "按承包商划分的ISA区域",
        description: "<h2>ISA承包商信息</h2> <table> <thead> <tr> <th>承包商ID</th> <th>首选承包商名称</th> <th>国籍</th> </tr> </thead> <tbody> <tr> <td>BGRPMN1</td> <td>德国联邦地质科学和自然资源研究所 - PMN </td> <td>德国</td> </tr> <tr> <td>BGRPMS1</td> <td>德国联邦地质科学和自然资源研究所 - PMS </td> <td>德国</td> </tr> <tr> <td>BMJPMN1</td> <td>牙买加蓝色矿物有限公司（BMJ） - PMN</td> <td>牙买加</td> </tr> <tr> <td>BPHDCPMN1</td> <td>北京先驱高科技开发公司 - PMN</td> <td>中国</td> </tr> <tr> <td>BrazilCRFC1</td> <td>巴西矿产资源研究公司 - CRFC</td> <td>巴西</td> </tr> <tr> <td>CIICPMN1</td> <td>库克群岛投资公司 - PMN</td> <td>库克群岛</td> </tr> <tr> <td>CMMPMN1</td> <td>中国五矿集团公司 - PMN</td> <td>中国</td> </tr> <tr> <td>COMRACRFC1</td> <td> 中国大洋矿产资源研究开发协会 - CRFC </td> <td>中国</td> </tr> <tr> <td>COMRAPMN1</td> <td> 中国大洋矿产资源研究开发协会 - PMN </td> <td>中国</td> </tr> <tr> <td>COMRAPMS1</td> <td> 中国大洋矿产资源研究开发协会 - PMS </td> <td>中国</td> </tr> <tr> <td>DORDPMN1</td> <td>深海资源开发有限公司 - PMN</td> <td>日本</td> </tr> <tr> <td>GSRPMN1</td> <td>全球海洋矿产资源有限公司 - PMN</td> <td>比利时</td> </tr> <tr> <td>IFREMERPMN1</td> <td> 法国海洋开发研究院 - PMN </td> <td>法国</td> </tr> <tr> <td>IFREMERPMS1</td> <td> 法国海洋开发研究院 - PMS </td> <td>法国</td> </tr> <tr> <td>IndiaPMN1</td> <td>印度政府 - PMN</td> <td>印度</td> </tr> <tr> <td>IndiaPMS1</td> <td>印度政府 - PMS</td> <td>印度</td> </tr> <tr> <td>IOMPMN1</td> <td>国际海洋金属联合组织 - PMN</td> <td>国际组织</td> </tr> <tr> <td>JOGMECCRFC1</td> <td>日本石油天然气金属矿物资源机构 - CRFC</td> <td>日本</td> </tr> <tr> <td>KOREACRFC1</td> <td>韩国 - CRFC</td> <td>韩国</td> </tr> <tr> <td>KOREAPMN1</td> <td>韩国 - PMN</td> <td>韩国</td> </tr> <tr> <td>KOREAPMS1</td> <td>韩国 - PMS</td> <td>韩国</td> </tr> <tr> <td>MARAWAPMN1</td> <td>MARAWAPMN1 - PMN</td> <td>瑙鲁</td> </tr> <tr> <td>NORIPMN1</td> <td>挪威极地研究所 - PMN</td> <td>挪威</td> </tr> <tr> <td>OMSPMN1</td> <td>OMSPMN1 - PMN</td> <td>中国</td> </tr> <tr> <td>POLPMS1</td> <td>波兰海洋地质研究所 - PMS</td> <td>波兰</td> </tr> <tr> <td>RUSFEDPMS1</td> <td>俄罗斯联邦自然资源和环境部 - PMS</td> <td>俄罗斯</td> </tr> <tr> <td>RUSMNRCRFC1</td> <td>俄罗斯自然资源部 - CRFC1</td> <td>俄罗斯</td> </tr> <tr> <td>TOMLPMN1</td> <td>汤加海洋矿产有限公司 - PMN</td> <td>汤加</td> </tr> <tr> <td>UKSRLPMN1</td> <td>英国海底资源有限公司 - PMN1</td> <td>英国</td> </tr> <tr> <td>UKSRLPMN2</td> <td>英国海底资源有限公司 - PMN2</td> <td>英国</td> </tr> <tr> <td>YUZHPMN1</td> <td>俄罗斯南海地质协会 - PMN</td> <td>俄罗斯</td> </tr> </tbody> </table>",
        schema: {
            layer: {
                keyword: "资源区域",
                "enum": {
                    "CFC Reserved Areas": "CFC保留区域",
                    "CFC Exploration Areas": "CFC勘探区域",
                    "PMN Reserved Areas": "PMN保留区域",
                    "PMN Exploration Areas": "PMN勘探区域",
                    "PMS Exploration Areas": "PMS勘探区域"
                }
            },
            contract: {
                keyword: "合同ID",
                "enum": {
                    BrazilCRFC1: "巴西CRFC1",
                    BGRPMN1: "德国联邦地质科学和自然资源研究所PMN1",
                    IFREMERPMN1: "法国海洋开发研究院PMN1",
                    KOREACRFC1: "韩国CRFC1",
                    KOREAPMN1: "韩国PMN1",
                    JOGMECCRFC1: "日本石油天然气金属矿物资源机构CRFC1",
                    IFREMERPMS1: "法国海洋开发研究院PMS1",
                    IOMPMN1: "国际海洋金属联合组织PMN1",
                    BPHDCPMN1: "北京先驱高科技开发公司PMN1",
                    DORDPMN1: "深海资源开发有限公司PMN1",
                    POLPMS1: "波兰海洋地质研究所PMS1",
                    UKSRLPMN2: "英国海底资源有限公司PMN2",
                    UKSRLPMN1: "英国海底资源有限公司PMN1",
                    YUZHPMN1: "俄罗斯南海地质协会PMN1",
                    BMJPMN1: "牙买加蓝色矿物有限公司PMN1",
                    RUSMNRCRFC1: "俄罗斯自然资源部CRFC1",
                    CIICPMN1: "库克群岛投资公司PMN1",
                    IndiaPMS1: "印度政府PMS1",
                    IndiaPMN1: "印度政府PMN1",
                    OMSPMN1: "OMS PMN1",
                    RUSFEDPMS1: "俄罗斯联邦自然资源和环境部PMS1",
                    CRFCReserved: "CRFC保留",
                    GSRPMN1: "全球海洋矿产资源有限公司PMN1",
                    KOREAPMS1: "韩国PMS1",
                    MARAWAPMN1: "MARWA PMN1",
                    COMRAPMS1: "中国大洋矿产资源研究开发协会PMS1",
                    COMRACRFC1: "中国大洋矿产资源研究开发协会CRFC1",
                    CMMPMN1: "中国五矿集团公司PMN1",
                    NORIPMN1: "挪威极地研究所PMN1",
                    TOMLPMN1: "汤加海洋矿产有限公司PMN1",
                    BGRPMS1: "德国联邦地质科学和自然资源研究所PMS1",
                    COMRAPMN1: "中国大洋矿产资源研究开发协会PMN1",
                    PMNReserved: "PMN保留",
                    "PMS Reserved": "PMS保留区域",
                    "PMS Exploration Areas": "PMS勘探区域"
                }
            }
        }
    },
    "public-isa-layers": {
        name: "按资源类型划分的ISA区域",
        description: "该图层显示国际海底管理局在所有海洋区域和海底矿产资源类型中管理的区域。\n\n勘探区域是已根据15年合同授予国家或由国家赞助的个体承包商进行矿产资源勘探的区域。这使合同持有人能够进行海底调查和环境研究，以评估资源和区域。如果国家或承包商申请商业开采许可证，这些区域最终可能成为获许可的开采区域。\n\n保留区域是国际海底管理局代表发展中国家预留的区域，以保障未来获得这些共同遗产资源的机会和途径。\n\n特别环境利益区（APEI）：这些区域受到保护，免受未来矿产资源开采，以保护生物多样性和生态系统健康。国际海底管理局的区域环境管理计划（REMP）最初设立了9个APEI，但截至2021年12月又增加了4个。国际海底管理局迄今为止已指定了13个APEI，保护太平洋克拉里昂-克利珀顿区近200万平方公里的海域。\n\nCFC勘探区域：根据国际海底管理局获得勘探许可的富钴铁锰结壳资源区域。\n\nCFC保留区域：根据国际海底管理局保留的富钴铁锰结壳资源区域。\n\n克拉里昂-克利珀顿区管理区域：该区域包括东太平洋克拉里昂-克利珀顿区的整个管理区域，包括所有勘探区域、保留区域和特别环境利益区。克拉里昂-克利珀顿区横跨夏威夷和墨西哥之间的450万平方公里海域。\n\nPMN勘探区域：根据国际海底管理局获得勘探许可的多金属结核资源区域。\n\nPMN保留区域：根据国际海底管理局保留的多金属结核资源区域。\n\nPMS勘探区域：根据国际海底管理局获得勘探许可的多金属硫化物资源区域。",
        schema: {
            label: {
                keyword: "资源区域",
                "enum": {
                    "CFC Reserved Areas": "CFC保留区域",
                    "PMN Exploration Areas": "PMN勘探区域",
                    "PMS Exploration Areas": "PMS勘探区域",
                    "PMN Reserved Areas": "PMN保留区域",
                    "Areas of particular environmental interest within the Clarion-Clipperton Zone": "克拉里昂-克利珀顿区内的特别环境利益区",
                    "Clarion-Clipperton Zone management area": "克拉里昂-克利珀顿区管理区",
                    "CFC Exploration Areas": "CFC勘探区域"
                }
            },
            layer: {
                keyword: "图层",
                "enum": {
                    "GIS-CCZ-Management-Areas — CCZ_Management_Areas.shp copy": "克拉里昂-克利珀顿区管理区域",
                    "ISAwebsite_APEIs — ISAwebsite_APEIs Dissolved": "特别环境利益区",
                    "ISAwebsite_fclContractAreasCRFC — ISAwebsite_fclContractAreasCRFC Dissolved": "CFC勘探区域",
                    "ISAwebsite_fclContractAreasCRFCres — ISAwebsite_fclContractAreasCRFCres Dissolved": "CFC保留区域",
                    "ISAwebsite_fclContractAreasPMN — ISAwebsite_fclContractAreasPMN Dissolved": "PMN勘探区域",
                    "ISAwebsite_fclContractAreasPMNres — ISAwebsite_fclContractAreasPMNres Dissolved": "PMN保留区域",
                    "ISAwebsite_fclContractAreasPMS — ISAwebsite_fclContractAreasPMS Dissolved": "PMS勘探区域"
                }
            }
        }
    },
    "public-location-labels": {
        name: "位置标签",
        description: "国家、地点和海洋数据集标签的组合"
    },
    "public-mangroves": {
        name: "红树林",
        description: "<h2>概述</h2>\n<ul>\n<li>红树林是能够在盐水环境中生存的树木或灌木，通常生长在热带和亚热带地区的潮间带。红树林森林被认为是蓝碳栖息地，能够改善水质，稳定和保护海岸线，并为鸟类、动物和海洋生物提供庇护所。该数据集使用地球观测卫星影像显示红树林的全球分布。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://data.unep-wcmc.org/datasets/4'>Giri C, Ochieng E, Tieszen LL, Zhu Z, Singh A, Loveland T, Masek J, Duke N (2011). 利用地球观测卫星数据的世界红树林森林状况和分布（版本1.4，由UNEP-WCMC更新）。全球生态与生物地理学20: 154-159. DOI: https://doi.org/10.34892/1411-w728.</a></li>"
    },
    "public-marine-ecoregions": {
        name: "海洋生态区（MEOW）",
        description: "<h2>概述</h2><ul><li>海洋生态区是对世界沿海和大陆架水域的生物地理分类。该数据集为与海洋环境生物多样性相关的广泛分析提供了地理框架。</li><ul><h2>来源</h2><ul><a href='https://geospatial.tnc.org/datasets/ed2be4cf8b7a451f84fd093c2e7660e3/explore'>大自然保护协会。</a></li>",
        schema: {
            REALM: {
                keyword: "领域",
                "enum": {
                    "Temperate Southern Africa": "南温带非洲",
                    "Temperate Northern Pacific": "北温带太平洋",
                    "Tropical Atlantic": "热带大西洋",
                    "Southern Ocean": "南大洋",
                    "Western Indo-Pacific": "西印度洋-太平洋",
                    "Temperate South America": "南温带南美洲",
                    "Central Indo-Pacific": "中印度洋-太平洋",
                    "Temperate Northern Atlantic": "北温带大西洋",
                    Arctic: "北极",
                    "Temperate Australasia": "温带澳大拉西亚",
                    "Tropical Eastern Pacific": "热带东太平洋",
                    "Eastern Indo-Pacific": "东印度洋-太平洋"
                }
            }
        }
    },
    "public-mediterranean-area-of-interest-1": {
        name: "感兴趣区域",
        description: "感兴趣区域"
    },
    "public-mexico-fishing-effort": {
        name: "墨西哥VMS",
        description: "船舶监控系统（VMS）数据由哥斯达黎加渔业和水产养殖研究所提供。数据通过厄瓜多尔的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为表观捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热力图上。VMS的数据广播方式与AIS不同，可能提供不同的完整性、准确性和质量度量。海洋渔业观察正在不断改进其跨所有广播数据格式的算法，以算法方式识别\"表观捕捞活动\"。可能存在一些捕捞活动未被识别，或者热力图可能显示实际未发生捕捞时的表观捕捞活动。出于这些原因，海洋渔业观察将\"捕捞活动\"、\"捕捞\"或\"捕捞努力量\"等术语限定为表观而非确定。任何和所有海洋渔业观察关于\"表观捕捞活动\"的信息都应被视为估计值，必须由用户自行决定是否依赖。海洋渔业观察的捕捞检测算法使用观察者收集的实际捕捞事件数据开发和测试，并结合对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕捞活动分类数据并改进自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "航向",
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    fishing: "渔船"
                }
            }
        }
    },
    "public-mexico-fishing-vessels": {
        name: "墨西哥VMS（渔船）",
        description: "墨西哥船舶监控系统（VMS）公开数据集",
        schema: {
            source: "来源"
        }
    },
    "public-mexico-presence": {
        name: "墨西哥船舶监控系统",
        description: "这些墨西哥VMS数据可在CONAPESCA的开放数据门户上获取。数据于2021年3月24日发布，并继续每月上传。\n\nCONAPESCA是SAGARPA的一个分散机构，专注于合法性、质量、透明度，并负责促进和发展与不同机构的协调机制，以实施推动和促进墨西哥渔业和水产养殖业竞争和可持续发展的政策、计划和规范；这反过来将提高墨西哥人的生活质量。\n\n对于持有有效捕鱼许可证和/或许可证的人，在以下情况下必须使用VMS：使用功率超过80马力（相当于59.68千瓦）的固定发动机、平甲板、长度超过10.5米的船舶，在太平洋或墨西哥湾和加勒比海的联邦管辖水域作业，在墨西哥专属经济区内作业，或悬挂墨西哥国旗在公海上进行捕鱼活动的船舶。\n\n以下船舶豁免本规定：定期持续进行内河航行的船舶、娱乐或运动捕鱼船舶、《一般可持续渔业和水产养殖法》第4条第XVII款规定的船舶，以及根据2013年5月2日在《联邦官方公报》上公布的“关于在总吨位低于三百单位且长度大于七米的船舶上分配和安装传输设备的标准的协议”规定的船舶。",
        schema: {
            speed: "速度",
            bearing: "航向",
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    fishing: "渔船",
                    "international traffic": "国际交通",
                    "national traffic": "国内交通",
                    tug: "拖船",
                    boat: "小船",
                    auxiliary: "辅助船"
                }
            }
        }
    },
    "public-mexico-vessel-identity-fishing": {
        name: "墨西哥船舶监控系统（渔船）",
        description: "墨西哥船舶监控系统（VMS）公开数据集"
    },
    "public-mid-atlantic-isa-claim-areas": {
        name: "中大西洋ISA许可证区域",
        description: "该图层展示了中大西洋海脊国际海底管理局（ISA）海底采矿许可证区域，包含多金属硫化物。目前该区域的勘探租约由法国、俄罗斯和波兰持有。",
        schema: {
            type: "类型",
            label: "标签",
            contractor: "承包商"
        }
    },
    "public-mp-as-mp-atlas": {
        name: "海洋保护区（MPAtlas）",
        description: "海洋保护区（MPA）是为长期保护而划定的海洋区域。这些区域可以有不同级别的保护，其边界内允许或禁止的活动范围也有很大差异"
    },
    "public-mp-atlas": {
        name: "海洋保护区（MPAtlas）",
        description: "<p><a href=\"https://www.science.org/doi/10.1126/science.abf0861/\" target=\"_blank\" >海洋保护区指南</a>旨在填补现有海洋保护区分类和评估工具的空白，帮助确定海洋保护区实现预期保护成果的可能性。在过去几年中，MPAtlas团队和主要合作者已将海洋保护区指南框架应用于世界各地的海洋保护区，以更清晰地了解全球海洋保护情况，其中包括最近一项为全球\"30x30\"目标建立基线的研究 - 出版物：<a href=\"https://conbio.onlinelibrary.wiley.com/doi/10.1111/conl.13020\" target=\"_blank\" >海洋保护质量落后于数量</a>。MPAtlas是海洋保护区指南评估和相关数据的在线存储库。建立阶段代表海洋保护区处于成为海洋保护区的哪个阶段。<u>提议/承诺</u>：创建海洋保护区的意向已公开。<u>已指定</u>：海洋保护区通过法律手段或其他权威规则制定而建立/认可。<u>已实施</u>：海洋保护区被确认在\"水中\"运营，管理计划已激活。<u>积极管理中</u>：海洋保护区管理正在进行中，包括监测、定期审查和根据需要进行调整，以实现生物多样性保护和其他生态及社会目标。保护级别代表海洋保护区免受七种主要人类活动影响的程度，以及可能产生积极生物多样性成果的程度。<u>完全保护</u>：不允许来自采掘或破坏性活动的影响，并将所有可减少的影响降至最低。<u>高度保护</u>：仅允许总影响低的轻度采掘活动，所有其他可减少的影响均降至最低。<u>轻度保护</u>：存在一定的生物多样性保护，但允许可能产生中度至显著影响的采掘或破坏性活动。<u>最低保护</u>：存在广泛的采掘或破坏性活动，对生物多样性的保护有限。</p>",
        schema: {
            establishment_stage: {
                keyword: "建立阶段",
                "enum": {
                    "proposed/committed": "提议/承诺",
                    designated: "已指定",
                    "actively managed": "积极管理中",
                    implemented: "已实施",
                    unknown: "未知"
                }
            },
            mpaguide_protection_level: {
                keyword: "保护级别",
                "enum": {
                    unknown: "未知",
                    light: "轻保护",
                    full: "完全保护",
                    high: "高",
                    incompatible: "不兼容",
                    minimal: "最小保护"
                }
            }
        }
    },
    "public-mpa-all": {
        name: "海洋保护区（WDPA）",
        description: "海洋保护区（MPA）是为长期保护而划定的海洋区域。这些区域可以有不同级别的保护，其边界内允许或禁止的活动范围也有很大差异。来源：世界保护区数据库。有关该图层的更多详细信息，请参阅<a href='https://globalfishingwatch.org/faqs/reference-layer-sources/' target='_blank' rel=noopener'>元数据信息</a>。"
    },
    "public-mpa-no-take": {
        name: "海洋保护区 - 禁止捕捞",
        description: "海洋保护区（MPA）一词包括海洋保护区、完全保护的海洋区域、禁止捕捞区、海洋保护区、海洋保护区、海洋公园、当地管理的海洋区域等。其中许多具有完全不同的保护级别，其边界内允许或禁止的活动范围也有很大差异。禁止捕捞图层是使用海洋保护区Planet WDPA提供的数据创建的，使用过滤器NO_TAKE = 'All'。来源：世界保护区数据库（WDPA）"
    },
    "public-mpa-no-take-partial": {
        name: "海洋保护区 - 部分禁止捕捞",
        description: "海洋保护区术语包括海洋保护区、完全保护的海洋区域、禁渔区、海洋保护区、海洋圣所、海洋公园、本地管理的海洋区域等。其中许多具有完全不同的保护级别，其边界内允许或禁止的活动范围也有很大差异。来源：世界保护区数据库（WDPA）"
    },
    "public-mpa-restricted": {
        name: "海洋保护区 - 限制（来源：WDPA）",
        description: "海洋保护区（MPA）一词包括海洋保护区、完全保护的海洋区域、禁渔区、海洋保护区、海洋保护区、海洋公园、当地管理的海洋区域等。其中许多具有完全不同的保护级别，其边界内允许或禁止的活动范围也有很大差异。禁渔图层是使用海洋保护区Planet WDPA提供的数据创建的，使用过滤器NO_TAKE = 'Part'。来源：世界保护区数据库（WDPA）"
    },
    "public-no-take-zone-1618836692786": {
        name: "海洋保护区",
        description: "90% of EEZ"
    },
    "public-northwest-pacific-isa-claim-areas": {
        name: "西北太平洋ISA许可证区域",
        description: "该图层展示了西北太平洋国际海底管理局（ISA）海底采矿许可证区域，主要包含富钴铁锰结壳和多金属结核资源。中国、日本、俄罗斯和韩国等多个国家在该区域持有勘探租约。",
        schema: {
            type: "类型",
            label: "标签",
            contractor: "承包商"
        }
    },
    "public-norway-fishing-effort": {
        name: "挪威VMS",
        description: "船舶监控系统（VMS）数据由挪威渔业局提供。数据通过挪威的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶位置、速度、航向和移动信息。海洋渔业观察使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为明显捕捞或非捕捞，并将前者显示在海洋渔业观察的捕捞活动热力图上。VMS的数据广播方式与AIS不同，可能提供不同的完整性、准确性和质量度量。海洋渔业观察正在不断改进其跨所有广播数据格式的算法，以算法方式识别\"明显捕捞活动\"。可能存在一些捕捞活动未被识别，或者热力图可能显示实际未发生捕捞时的明显捕捞活动。出于这些原因，海洋渔业观察将\"捕捞活动\"、\"捕捞\"或\"捕捞努力量\"等术语限定为明显而非确定的。任何和所有海洋渔业观察关于\"明显捕捞活动\"的信息都应被视为估计值，必须由用户自行决定是否依赖。海洋渔业观察的捕捞检测算法使用观察者收集的实际捕捞事件数据开发和测试，并结合对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕捞活动分类数据并改进自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "public-norway-fishing-vessels": {
        name: "挪威VMS（渔船）",
        description: "挪威船舶监控系统（VMS）公开数据集",
        schema: {
            source: "来源"
        }
    },
    "public-norway-non-fishing-vessels": {
        name: "挪威VMS（非渔船）",
        description: "挪威船舶监控系统（VMS）公开数据集",
        schema: {
            source: "来源"
        }
    },
    "public-norway-presence": {
        name: "挪威船舶监控系统",
        description: "船舶监控系统（VMS）数据由挪威渔业局提供。数据通过挪威的船舶监控系统经卫星收集，并在三天延迟后发布，包含船舶位置、速度、航向和移动信息。活动图层显示船舶存在的热力图。存在图层中的每个点代表船舶的一个位置，但并非所有位置都显示。船舶位置每小时显示一次。您可以选择一个位置查看船舶的完整航迹。",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "public-norway-vessel-identity-fishing": {
        name: "挪威船舶监控系统（渔船）",
        description: "挪威船舶监控系统（VMS）公开数据集"
    },
    "public-norway-vessel-identity-non-fishing": {
        name: "挪威船舶监控系统（非渔船）",
        description: "挪威船舶监控系统（VMS）公开数据集"
    },
    "public-paa-duke": {
        name: "PAAS（渔船辅助服务）",
        description: "<p>这个全球优惠准入区域（PAA）数据库是根据Basurto等人（2023）和FAOLEX数据库（https://www.fao.org/faolex/en/）为照明隐藏收获（IHH）倡议确定的44个国家的数据构建的。本研究中确定的44个国家的总PAAs（n = 63）可能被视为下限而非全面，因为政府也可以通过以下方式通过法律或法规建立PAAs：（i）与渔业部门无关且在FAOLEX数据库其他地方分类，因此未被搜索，或（ii）未在其中报告或捕获。最近一次审查FAOLEX以识别PAAs的时间是2022年。为了对PAAs进行制图和空间分析，使用每个PAA的定义参数（即距海岸线或基线的距离、深度或给定的坐标集或海底特征周围的缓冲距离）创建了PAA边界的地理数据库。基线从Flanders海洋研究所（2023）的第12版全球EEZ数据库中提取，由\"直线基线\"特征定义。海岸线数据集是ESRI的2014年全球海岸线，与Flanders海洋研究所全球EEZ数据库使用的海岸线数据集相同。深度数据从GEBCO 2023全球地形数据集中提取。可能的情况下，杜克大学联系了当地专家审查边界，以确认我们对FAOLEX和相关法律或法规的解释与当地渔民使用的一致。如果您对PAA边界有反馈、关于此处未反映的PAAs的信息或其他问题，请联系ssf-paa-info@duke.edu。有关PAAs及其管理方式的更多信息，请参见杜克大学Basurto等人（2024）的出版物：<a href=\"https://doi.org/10.1038/s44183-024-00096-0\" target=\"_blank\" >https://doi.org/10.1038/s44183-024-00096-0</a >。请注意，PAA没有单一的定义，因此每个国家将根据其具体情况和需求定义和管理PAAs。</p>"
    },
    "public-panama-fishing-effort": {
        name: "巴拿马VMS",
        description: "船舶监控系统（VMS）数据由巴拿马水产资源局（ARAP）提供。数据通过卫星由巴拿马的VMS系统接收，包含船舶身份、渔具类型、位置、速度、方向等信息。巴拿马的运输船数据也可在此处获取。运输船数据层中的每个点代表运输船的一个位置，但并非所有位置都显示。运输船位置每天显示一次。在未来，我们预计能够显示更多位置。点击运输船的位置可查看船舶的完整航迹。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。VMS的数据广播方式与AIS有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼存在算法（与AIS一样）是通过算法识别\"明显捕鱼活动\"的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"和\"捕鱼努力\"等术语限定为\"明显\"而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。海洋渔业观察的捕鱼存在算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕鱼活动分类数据和自动分类技术。",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "public-panama-fishing-vessels": {
        name: "巴拿马VMS（公共渔船）",
        description: "巴拿马船舶监控系统（VMS）公开数据集",
        schema: {
            source: "来源"
        }
    },
    "public-panama-non-fishing-vessels": {
        name: "巴拿马VMS（公共非渔船）",
        description: "巴拿马船舶监控系统（VMS）- 运输船公开数据集",
        schema: {
            source: "来源"
        }
    },
    "public-panama-vessel-identity-fishing": {
        name: "巴拿马船舶监控系统（公开渔船）",
        description: "巴拿马船舶监控系统（VMS）公开数据集"
    },
    "public-panama-vessel-identity-non-fishing": {
        name: "巴拿马船舶监控系统（公开非渔船）",
        description: "巴拿马船舶监控系统（VMS）- 运输船公开数据集"
    },
    "public-peru-fishing-effort": {
        name: "秘鲁VMS",
        description: "船舶监控系统（VMS）数据由秘鲁政府生产部渔业部门（PRODUCE）提供。包含秘鲁数据需要实施10天的发布延迟。数据通过卫星和地面接收器使用其船舶监控系统（VMS）收集，包含船舶身份、渔具类型、位置、速度、方向等信息。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将这些船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。VMS的数据广播方式与AIS有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼存在算法（与AIS一样）是通过算法识别\"明显捕鱼活动\"的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为\"明显\"而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。海洋渔业观察的捕鱼存在算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕鱼活动分类数据和自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    industrial: "工业",
                    artisanal: "手工",
                    "small-scale": "小规模",
                    "not defined": "未定义"
                }
            },
            speed: "速度",
            origin: {
                keyword: "来源地",
                "enum": {
                    PER: "秘鲁",
                    Foreign: "外国"
                }
            },
            bearing: "航向"
        }
    },
    "public-peru-fishing-vessels": {
        name: "秘鲁VMS（渔船）",
        description: "秘鲁船舶监控系统（VMS）公开数据集"
    },
    "public-peru-presence": {
        name: "秘鲁船舶监控系统",
        description: "船舶监控系统（VMS）数据由秘鲁政府生产部渔业部门（PRODUCE）提供。包含秘鲁数据需要实施10天的发布延迟。数据通过卫星和地面接收器使用其船舶监控系统（VMS）收集，包含船舶身份、渔具类型、位置、速度、方向等信息。海洋渔业观察使用为自动识别系统（AIS）数据开发的相同算法分析这些数据，以识别捕鱼活动和行为。该算法将这些船舶的每个广播数据点分类为明显捕鱼或非捕鱼，并在海洋渔业观察的捕鱼活动热图上显示前者。VMS的数据广播方式与AIS有很大不同，可能在完整性、准确性和质量方面给出不同的衡量标准。随着时间的推移，我们的算法将在所有广播数据格式中得到改进。海洋渔业观察的VMS捕鱼检测算法（与AIS一样）是通过算法识别\"明显捕鱼活动\"的最佳努力。可能存在一些捕鱼活动未被识别，或者热图可能显示明显捕鱼活动而实际上并未发生捕鱼的情况。出于这些原因，海洋渔业观察将\"捕鱼活动\"、\"捕鱼\"或\"捕鱼努力\"等术语限定为\"明显\"而非确定的。任何和所有关于\"明显捕鱼活动\"的海洋渔业观察信息都应被视为估计值，您必须自行承担风险依赖。海洋渔业观察的捕鱼检测算法使用观察员收集的实际捕鱼事件数据进行开发和测试，并结合对AIS船舶移动数据的专家分析，从而手动分类了数千个已知的捕鱼事件。海洋渔业观察还通过我们的研究计划与学术研究人员广泛合作，共享捕鱼活动分类数据和自动分类技术。",
        schema: {
            fleet: {
                keyword: "船队",
                "enum": {
                    industrial: "工业",
                    artisanal: "手工",
                    "small-scale": "小规模",
                    "not defined": "未定义"
                }
            },
            origin: {
                keyword: "来源地",
                "enum": {
                    PER: "秘鲁",
                    Foreign: "外国"
                }
            }
        }
    },
    "public-peru-vessel-identity-fishing": {
        name: "秘鲁船舶监控系统（渔船）",
        description: "秘鲁船舶监控系统（VMS）公开数据集"
    },
    "public-pmn-exploration-areas-individual": {
        name: "PMN勘探区域",
        description: "多金属结核分布在深海平原。这些结核可以在3000米至6500米的深度发现，在太平洋和中印度洋盆地高度丰富。结核以每百万年1-3毫米的速度形成，周围水中的金属沉淀在小颗粒上，如沙粒或贝壳碎片，形成独特且知之甚少的生物多样性栖息地。它们主要由锰、镍、钴、铜和稀土元素组成。国际海底管理局下的勘探区域是向特定国家和相关承包商颁发矿产资源勘探许可证的区域。每个承包商分配75,000平方公里用于多金属结核勘探区域。",
        schema: {
            status: "状态",
            remarks: {
                keyword: "备注",
                "enum": {
                    xx: "xx",
                    "Total exploration area of GSR (PMN) is 41,468.91606 sq.km": "GSR（PMN）的总勘探面积为41,468.91606平方公里",
                    "Total exploration area of IOM (PMN) is 75,000 sq.km; AreaKM2 was calculated by ISA": "IOM（PMN）的总勘探面积为75,000平方公里；面积由ISA计算",
                    "Total exploration area of Yuzhmorgeologiya (PMN) is 75,000 sq.km; AreaKM2 was calculated by ISA": "南海地质协会（PMN）的总勘探面积为75,000平方公里；面积由ISA计算",
                    "Total exploration area of Korea (PMN) is 75,000 sq.km; AreaKM2 was calculated by ISA": "韩国（PMN）的总勘探面积为75,000平方公里；面积由ISA计算",
                    "Total exploration area of COMRA (PMN) is 75,000 sq.km; AreaKM2 was calculated by ISA": "中国大洋矿产资源研究开发协会（PMN）的总勘探面积为75,000平方公里；面积由ISA计算",
                    "Total exploration area of DORD (PMN) is 75,000 sq.km; AreaKM2 was calculated by ISA": "DORD（PMN）的总勘探面积为75,000平方公里；面积由ISA计算",
                    "Total exploration area of IFREMER (PMN) is 75,000 sq.km; AreaKM2 was calculated by ISA": "法国海洋开发研究院（PMN）的总勘探面积为75,000平方公里；面积由ISA计算",
                    "Total exploration area of India (PMN) is 75,000 sq.km, AreaKM2 was calculated by ISA": "印度（PMN）的总勘探面积为75,000平方公里；面积由ISA计算",
                    "Total exploration area of GSR (PMN) is 76,728 sq.km; AreaKM2 was calculated by ISA": "GSR（PMN）的总勘探面积为76,728平方公里；面积由ISA计算",
                    "Total exploration area of MARAWA (PMN) is 74,990 sq.km; AreaKM2 was calculated by ISA": "MARAWA（PMN）的总勘探面积为74,990平方公里；面积由ISA计算",
                    "Total exploration area of CIIC (PMN) is 71,937 sq.km; AreaKM2 was calcualted by ISA": "CIIC（PMN）的总勘探面积为71,937平方公里；面积由ISA计算"
                }
            },
            act_date: {
                keyword: "生效日期",
                "enum": {
                    "985816800000": "985816800000",
                    "1717970400000": "1717970400000"
                }
            },
            area_key: "区域关键字",
            blk_cell: "区块单元格",
            blk_orig: "区块来源",
            sub_area: "子区域",
            area_km_2: {
                keyword: "面积（平方公里）",
                "enum": {
                    "74919": "74919",
                    "2182.876": "2182.876"
                }
            },
            area_type: "区域类型",
            clst_orig: "集群起源",
            cluster_id: "集群ID",
            blk_cell_id: "区块单元ID",
            contract_id: {
                keyword: "合同ID",
                "enum": {
                    KOREAPMN1: "韩国PMN1",
                    IOMPMN1: "国际海洋金属联合组织PMN1",
                    DORDPMN1: "深海资源开发有限公司PMN1",
                    BMJPMN1: "牙买加蓝色矿物有限公司PMN1",
                    IndiaPMN1: "印度政府PMN1",
                    TOMLPMN1: "汤加海洋矿产有限公司PMN1",
                    IFREMERPMN1: "法国海洋开发研究院PMN1",
                    BGRPMN1: "德国联邦地质科学和自然资源研究所PMN1",
                    BPHDCPMN1: "北京先驱高科技开发公司PMN1",
                    UKSRLPMN2: "英国海底资源有限公司PMN2",
                    UKSRLPMN1: "英国海底资源有限公司PMN1",
                    YUZHPMN1: "俄罗斯南海地质协会PMN1",
                    CIICPMN1: "库克群岛投资公司PMN1",
                    OMSPMN1: "OMS PMN1",
                    GSRPMN1: "全球海洋矿产资源有限公司PMN1",
                    MARAWAPMN1: "MARWA PMN1",
                    CMMPMN1: "中国五矿集团公司PMN1",
                    NORIPMN1: "挪威极地研究所PMN1",
                    COMRAPMN1: "中国大洋矿产资源研究开发协会PMN1"
                }
            }
        }
    },
    "public-pmn-reserved-areas-individual": {
        name: "PMN保留区域",
        description: "多金属结核分布在深海平原。这些结核可以在3000米至6500米的深度发现，在太平洋和中印度洋盆地高度丰富。结核以每百万年1-3毫米的速度形成，周围水中的金属沉淀在小颗粒上，如沙粒或贝壳碎片，形成独特且知之甚少的生物多样性栖息地。它们主要由锰、镍、钴、铜和稀土元素组成。国际海底管理局下的保留区域是确保发展中国家未来能够获取深海矿产资源的关键机制。这些区域通常由发达国家在申请勘探权时贡献。",
        schema: {
            status: "状态",
            remarks: {
                keyword: "备注",
                "enum": {
                    "Origin:INDIA": "来源：印度",
                    "Origin:COMRA": "来源：中国大洋矿产资源研究开发协会",
                    "Origin:Yuzhmorgeologia": "来源：俄罗斯联邦水文气象和环境监测局",
                    "Origin:DORD": "来源：法国海洋开发研究院深海研究中心",
                    "Origin:IFREMER": "来源：法国海洋开发研究院",
                    "Origin:Government of the Republic of Korea": "来源：大韩民国政府",
                    "Origin:IOM": "来源：国际海洋研究所",
                    "Origin:BGR": "来源：德国联邦地质科学和自然资源研究所",
                    "Origin:UKSRL-ll": "来源：英国海底资源有限公司"
                }
            },
            act_date: {
                keyword: "生效日期",
                "enum": {
                    "988322400000": "988322400000",
                    "1617487200000": "1617487200000"
                }
            },
            area_key: "区域关键字",
            blk_cell: "区块单元格",
            blk_orig: {
                keyword: "区块来源",
                "enum": {
                    "983401200000": "983401200000",
                    "986076000000": "986076000000"
                }
            },
            sub_area: "子区域",
            area_km_2: {
                keyword: "面积（平方公里）",
                "enum": {
                    "150000": "150000",
                    "1032.952": "1032.952"
                }
            },
            area_type: "区域类型",
            clst_orig: "集群起源",
            cluster_id: "集群ID",
            blk_cell_id: "区块单元ID",
            contract_id: {
                keyword: "合同ID",
                "enum": {
                    BPHDCPMN1: "BPHDCPMN1",
                    PMNReserved: "多金属结核保留区域"
                }
            }
        }
    },
    "public-pms-exploration-areas-individual": {
        name: "PMS勘探区域",
        description: "多金属硫化物，或海底块状硫化物，形成于洋中脊和弧后盆地附近的热液喷口，深度在约1000至4000米之间。它们是当地幔中过热的富含矿物质的流体被深水迅速冷却时形成的。快速冷却导致流体中的溶解金属沉淀为金属硫化物。这些硫化物和周围的多金属泥浆可能含有铜、锌、银和金。对于多金属硫化物，分配给每个承包商的勘探面积为10,000平方公里，由100个区块组成。每个区块不超过100平方公里。",
        schema: {
            status: "状态",
            act_date: {
                keyword: "生效日期",
                "enum": {
                    "1474840800000": "1474840800000",
                    "1698098400000": "1698098400000"
                }
            },
            area_key: "区域关键字",
            blk_cell: "区块单元格",
            blk_orig: {
                keyword: "区块来源",
                "enum": {}
            },
            sub_area: "子区域",
            area_km_2: {
                keyword: "面积（平方公里）",
                "enum": {
                    "1": "1",
                    "101": "101"
                }
            },
            area_type: "区域类型",
            clst_orig: {
                keyword: "集群起源",
                "enum": {
                    A: "A",
                    B: "B",
                    C: "C",
                    D: "D",
                    E: "E"
                }
            },
            cluster_id: {
                keyword: "集群ID",
                "enum": {
                    NR: "NR",
                    A: "A",
                    B: "B",
                    C: "C",
                    D: "D",
                    E: "E",
                    NA: "NA"
                }
            },
            blk_cell_id: {
                keyword: "区块单元ID",
                "enum": {}
            },
            contract_id: {
                keyword: "合同ID",
                "enum": {
                    KOREAPMS1: "韩国PMS1",
                    COMRAPMS1: "中国大洋矿产资源研究开发协会PMS1",
                    IFREMERPMS1: "法国海洋开发研究院PMS1",
                    POLPMS1: "波兰海洋地质研究所PMS1",
                    RUSFEDPMS1: "俄罗斯联邦自然资源和环境部PMS1",
                    BGRPMS1: "德国联邦地质科学和自然资源研究所PMS1",
                    IndiaPMS1: "印度政府PMS1"
                }
            }
        }
    },
    "public-png-fishing-effort": {
        name: "巴布亚新几内亚VMS",
        description: "船舶监控系统（VMS）数据由巴布亚新几内亚国家渔业局提供。数据通过巴布亚新几内亚的船舶监控系统（VMS）经卫星收集，包含船舶标识符和位置，并在五天延迟后发布。海洋渔业观察组织为每个船舶位置推断速度和航向，并使用为自动识别系统（AIS）开发的相同算法分析这些数据，以识别捕捞活动和行为。该算法将船舶的每个广播数据点分类为明显捕捞或非捕捞，并在海洋渔业观察组织的捕捞活动热力图上显示前者。VMS与AIS的数据广播方式不同，可能会在完整性、准确性和质量方面产生不同的测量结果。海洋渔业观察组织持续改进其在所有广播数据格式上的算法，以通过算法识别'明显捕捞活动'。可能存在一些捕捞活动未被识别，或者热力图可能在实际未发生捕捞时显示明显捕捞活动。由于这些原因，海洋渔业观察组织将'捕捞活动'、'捕捞'或'捕捞努力量'等术语限定为明显而非确定的。任何和所有关于'明显捕捞活动'的海洋渔业观察组织信息都应被视为估计值，必须由用户自行斟酌。海洋渔业观察组织的捕捞检测算法是使用观察员收集的实际捕捞事件数据开发和测试的，并结合了对AIS船舶运动数据的专家分析，结果是对数千个已知捕捞事件的手动分类。海洋渔业观察组织还通过我们的研究计划与学术研究人员广泛合作，分享捕捞活动分类数据并改进自动分类技术",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "public-png-fishing-vessels": {
        name: "巴布亚新几内亚VMS（渔船）",
        description: "巴布亚新几内亚船舶监控系统（VMS）公开数据集",
        schema: {
            source: "来源"
        }
    },
    "public-png-presence": {
        name: "巴布亚新几内亚VMS",
        description: "船舶监控系统（VMS）数据由巴布亚新几内亚国家渔业局提供。数据通过巴布亚新几内亚国家VMS收集，该系统由渔业信息和管理系统（FIMS）提供。VMS数据包括船舶标识符和位置，并有五天延迟发布。\n\n活动图层显示船舶存在的热力图。存在数据通过每小时从船舶VMS传输的位置中获取两个位置来确定。",
        schema: {
            speed: "速度",
            bearing: "航向"
        }
    },
    "public-png-vessel-identity-fishing": {
        name: "巴布亚新几内亚VMS（渔船）",
        description: "巴布亚新几内亚船舶监控系统（VMS）公开数据集"
    },
    "public-ports": {
        name: "港口",
        description: "命名港口",
        schema: {
            name: "名称",
            port_id: "港口ID"
        }
    },
    "public-ports-v1": {
        name: "港口",
        description: "命名港口 v1"
    },
    "public-presence-viirs-match-prototype": {
        name: "VIIRS夜间灯光船舶探测",
        description: "夜间灯光船舶探测图层，称为可见红外成像辐射计套件或VIIRS，显示卫星通过夜间发光检测到的海上船舶。虽然不完全与渔船相关，但此活动图层很可能显示与鱿鱼捕捞等活动相关的船舶，这些船舶使用强光并在夜间捕捞。<br/>\n<br/>\n基于Suomi NPP卫星，VIIRS传感器每晚至少一次穿越整个地球，检测灯光以提供全球每日至少一次的观测。由于极轨卫星的轨道设计，靠近极地的区域每天会有更多的过境，而赤道区域每天只有一次过境。<br/> \n<br/>\n由于仅基于发光检测船舶，我们可以检测到可能不广播身份信息的个别船舶甚至整个渔船队，因此这些船舶可能不会在海洋渔业观察地图上的其他位置显示。海洋渔业观察组织接收由美国国家海洋和大气管理局（NOAA）VIIRS收集的微光成像数据处理后的船舶检测结果。船舶检测结果由科罗拉多矿业学院的<a href='https://eogdata.mines.edu/products/vbd/' target='_blank' rel=noopener'>地球观测组</a>近实时处理。这些数据被称为VIIRS船舶检测，可检测到船舶的存在，包括那些使用灯光吸引渔获或在夜间进行作业的捕鱼船。来自固定海上基础设施和其他非船舶来源的灯光被排除在外。<a href='https://eogdata.mines.edu/products/vbd/' target='_blank' rel=noopener'>了解更多关于VIIRS夜间灯光船舶检测的信息并下载数据</a>。<br/>\n<br/>\n海洋渔业观察组织开发了一个复杂的系统，将可用的自动识别系统（AIS）数据与相应的夜间灯光船舶检测结果匹配。这种匹配使用概率模型完成，该模型根据卫星VIIRS图像拍摄前后所有可用的AIS记录，以及将特定AIS消息与该图像上出现的任何船舶配对的概率，确定AIS消息/VIIRS检测对。利用这些信息，海洋渔业观察组织在VIIRS活动图层中添加了基于船舶类型和渔具类型过滤检测结果的实验性功能。<br/>\n<br/>\n超过85%的检测结果来自缺乏AIS或公开共享的船舶监控系统（VMS）应答器的船舶。全球范围内添加VIIRS图层使您能够快速过滤与AIS匹配或不匹配的夜间灯光检测结果，其中船舶识别信息可用。<br/>\n<br/>\n辐射亮度表示VIIRS传感器接收到的光源亮度。辐射亮度受月亮、云层和船舶与卫星的角度影响。两艘具有相同亮度或光强度的船舶可能根据条件具有不同的辐射亮度水平。一般来说，不使用灯光积极捕鱼的船舶可能具有较低的辐射亮度水平。当船舶接近海岸线时，应考虑例外情况。为了进一步探索夜间船舶灯光如何发出不同的辐射亮度水平，VIIRS活动图层可以过滤到与不同人类行为相关的特定感兴趣范围。<br/>\n<br/>\n使用夜间灯光检测数据的人员应考虑南大西洋异常（SAA），这是地球内部范艾伦辐射带处于最低高度的区域，允许更多来自太空的高能粒子穿透。当此类粒子撞击卫星上的传感器时，会产生虚假信号，可能导致算法将其识别为船舶检测。已经应用了过滤算法，但仍可能存在一些误识别。",
        schema: {
            source: {
                keyword: "来源",
                "enum": {
                    unknown: "未知",
                    chile_vms_aquaculture: "智利VMS水产养殖",
                    "peru.trasat_api": "秘鲁TRASAT API",
                    namibia_vms: "纳米比亚VMS",
                    indovms: "印度VMS",
                    mexico_vms: "墨西哥VMS",
                    chile_vms_small_fisheries: "小型渔业",
                    "peru.historic": "秘鲁历史数据",
                    chile_vms_industry: "工业",
                    ais_scored: "AIS评分数据",
                    AIS: "AIS",
                    panama_vms: "巴拿马VMS",
                    chile_vms_transport: "智利VMS运输船"
                }
            },
            matched: {
                keyword: "匹配状态",
                "enum": {
                    "true": "1",
                    "false": "0"
                }
            },
            radiance: {
                keyword: "辐射亮度",
                "enum": {
                    "1": "1",
                    "1000": "1000"
                }
            },
            shiptype: {
                keyword: "船舶类型",
                "enum": {
                    unknown: "未知",
                    fishing: "渔船",
                    carrier: "运输船",
                    support: "支持船"
                }
            },
            qf_detect: {
                keyword: "检测质量标志",
                "enum": {
                    "1": "1",
                    "2": "2",
                    "3": "3",
                    "5": "5",
                    "7": "7",
                    "10": "10"
                }
            }
        }
    },
    "public-protectedseas": {
        name: "海洋保护区（ProtectedSeas）",
        description: "海洋保护区（MPAs）是为长期保护而预留的海洋区域。这些区域可以有不同级别的保护，其边界内允许或禁止的活动范围差异很大。来源：ProtectedSeas Navigator。ProtectedSeas基于对海洋生物提取限制的分析，为每个区域分配一个渔业保护级别（LFP）评分。您可以使用过滤图标探索不同的LFP评分，分别是：限制最少：无已知捕鱼限制；限制较少：仅适用少量物种或渔具特定限制；中等限制：适用多项物种或渔具特定限制；严格限制：捕鱼基本被禁止，仅有少数例外；限制最严：禁止捕鱼。<a href='https://protectedseas.net/mpa-methods/' target='_blank' rel=noopener'>查看此图层的更多详细元数据信息</a>。",
        schema: {
            removal_of: {
                keyword: "渔业保护级别",
                "enum": {
                    "1": "1. 限制最少",
                    "2": "2. 限制较少",
                    "3": "3. 中等限制",
                    "4": "4. 严格限制",
                    "5": "5. 限制最严"
                }
            }
        }
    },
    "public-protectedseas-all": {
        name: "所有海洋保护区",
        description: "所有海洋保护区",
        schema: {
            category_name: {
                keyword: "类别名称",
                "enum": {
                    "IUCN MPA": "IUCN海洋保护区",
                    Other: "其他",
                    "Jurisdictional Authority Area": "管辖权限区域",
                    TBD: "待定",
                    "Fisheries Management Area": "渔业管理区",
                    "Recreational Area": "休闲区",
                    OECM: "其他有效区域保护措施",
                    "Vessel Restricted Area": "船舶限制区",
                    "Voluntary Conservation Measure Area": "自愿保护措施区",
                    "Vessel Reporting Area": "船舶报告区",
                    "Water Quality/Human Health Area": "水质/人类健康区域"
                }
            },
            removal_of_marine_life_is_prohibited: {
                keyword: "渔业保护级别",
                "enum": {
                    "1": "1. 限制最少",
                    "2": "2. 限制较少",
                    "3": "3. 中等限制",
                    "4": "4. 严格限制",
                    "5": "5. 限制最严"
                }
            }
        }
    },
    "public-rfmo": {
        name: "区域渔业管理组织",
        description: "区域渔业管理组织（RFMOs）是由对特定区域鱼类种群管理或养护有共同利益的国家组成的国际机构。一些组织管理特定区域内发现的所有鱼类种群，而另一些则专注于特定的高度洄游物种，尤其是金枪鱼。海洋渔业观察地图上的区域渔业管理组织目前包括粮农组织地理网络提供的所有区域渔业机构（RFB）区域，以及五个金枪鱼区域渔业管理组织提供的公约区域。有关此图层的更多详细元数据信息，请参阅<a href='https://globalfishingwatch.org/faqs/reference-layer-sources/' target='_blank' rel=noopener'>元数据信息</a>。",
        schema: {
            ID: {
                keyword: "区域渔业管理组织",
                "enum": {
                    APFIC: "APFIC - 亚太渔业委员会",
                    "BOBP-IGO": "BOBP-IGO - 孟加拉湾计划 - 政府间组织",
                    CCAMLR: "CCAMLR - 南极海洋生物资源养护公约",
                    CCBSP: "CCBSP - 白令海中部狭鳕资源养护和管理公约",
                    CCSBT: "CCSBT - 南方蓝鳍金枪鱼养护委员会",
                    "CCSBT Primary Area": "南方蓝鳍金枪鱼委员会主要区域",
                    COREP: "COREP - 几内亚湾区域渔业委员会",
                    CPPS: "CPPS - 南太平洋常设委员会",
                    CRFM: "CRFM - 加勒比区域渔业机制",
                    CTMFM: "CTMFM - 阿根廷/乌拉圭海洋前沿联合技术委员会",
                    FCWC: "FCWC - 几内亚湾中西部渔业委员会",
                    FFA: "FFA - 太平洋岛国论坛渔业局",
                    GFCM: "GFCM - 地中海渔业总委员会",
                    IATTC: "IATTC - 美洲热带金枪鱼委员会",
                    ICCAT: "ICCAT - 大西洋金枪鱼养护国际委员会",
                    ICES: "ICES - 国际海洋探索理事会",
                    IOTC: "IOTC - 印度洋金枪鱼委员会",
                    IPHC: "IPHC - 国际太平洋大比目鱼委员会",
                    LTA: "LTA - 坦噶尼喀湖管理局",
                    NAFO: "NAFO - 西北大西洋渔业组织",
                    NAMMCO: "NAMMCO - 北大西洋海洋哺乳动物委员会",
                    NASCO: "NASCO - 北大西洋鲑鱼养护组织",
                    NEAFC: "NEAFC - 东北大西洋渔业委员会",
                    NPAFC: "NPAFC - 北太平洋溯河鱼类委员会",
                    NPFC: "NPFC - 北太平洋渔业委员会",
                    OSPESCA: "OSPESCA - 中美洲渔业和水产养殖组织",
                    PERSGA: "PERSGA - 红海和亚丁湾环境养护区域组织",
                    PICES: "PICES - 北太平洋海洋科学组织",
                    RECOFI: "RECOFI - 区域渔业委员会",
                    SEAFDEC: "SEAFDEC - 东南亚渔业发展中心",
                    SIOFA: "SIOFA - 南印度洋渔业协定",
                    SPC: "SPC - 太平洋共同体",
                    SPRFMO: "SPRFMO - 南太平洋区域渔业管理组织",
                    SRFC: "SRFC - 次区域渔业委员会",
                    SWIOFC: "SWIOFC - 西南印度洋渔业委员会",
                    WCPFC: "WCPFC - 中西太平洋渔业委员会"
                }
            }
        }
    },
    "public-seagrasses": {
        name: "海草",
        description: "<h2>概述</h2>\n<ul>\n<li>海草是一种生产力丰富的生态系统，分布在全球浅海区域，为生物提供食物和栖息地，并在营养循环中发挥关键作用。该数据集展示了海草的全球分布。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://data.unep-wcmc.org/datasets/7'>UNEP-WCMC, Short FT (2021). 全球海草分布（版本7.1）。对Green和Short（2003）中使用的数据层的第七次更新。剑桥（英国）：联合国环境规划署世界保护监测中心。数据DOI：https://doi.org/10.34892/x6r3-d211。 </a></li>",
        schema: {
            GENUS: {
                keyword: "属",
                "enum": {}
            },
            FAMILY: {
                keyword: "科",
                "enum": {}
            },
            habitat: {
                keyword: "栖息地",
                "enum": {}
            },
            BIO_CLASS: {
                keyword: "生物分类",
                "enum": {}
            }
        }
    },
    "public-seamounts": {
        name: "海山",
        description: "<h2>概述</h2>\n<ul>\n<li>海山是海底火山形成的山脉，能够产生营养物质上升流，支持更高的生物生产力、物种丰富度和独特的群落。这个全球海底地貌特征数据集包括海山，海山被定义为从海底升起超过1000米的山峰。</li>\n<ul>\n<h2>来源</h2>\n<ul>\n <a href='https://bluehabitats.org/'>Blue Habitats. 海底地貌特征图 by Harris, P.T., Macmillan-Lawler, M., Rupp, J. 和 Baker, E.K. 2014. Geomorphology of the oceans. Marine Geology, 352: 4-24.</a></li>",
        schema: {
            Height: {
                keyword: "高度",
                "enum": {
                    "0": "0",
                    "8000": "8000"
                }
            }
        }
    },
    "public-south-atlantic-isa-claim-areas": {
        name: "南大西洋ISA许可证区域",
        description: "该图层展示了南大西洋国际海底管理局（ISA）海底采矿许可证区域，包含富钴铁锰结壳资源。巴西目前是该区域唯一持有租约的国家。",
        schema: {
            label: "标签",
            contractor: "承包商"
        }
    },
    "public-tristan-seamounts-200-1618586314138": {
        name: "水深：-200米",
        description: "深度：-200米"
    },
    "public-tristan-seamounts-3000-1618586349746": {
        name: "水深：-3000米",
        description: "深度：-3000米"
    },
    "public-tristan-seamounts-existing-1618586378121": {
        name: "现有海山捕捞区",
        description: "专属经济区的2%"
    },
    "public-tuna-rfmo": {
        name: "区域渔业管理组织",
        description: "区域渔业管理组织（RFMOs）是由对特定区域鱼类种群管理或养护有共同利益的国家组成的国际机构。一些组织管理特定区域内发现的所有鱼类种群，而另一些则专注于特定的高度洄游物种，尤其是金枪鱼。海洋渔业观察地图上的区域渔业管理组织目前包括五个金枪鱼区域渔业管理组织。<a href='https://globalfishingwatch. org/faqs/reference-layer-sources/' target='_blank' rel=noopener'>查看此图层的更多详细元数据信息</a>。"
    },
    "public-wdpa-may-2021-marine": {
        name: "海洋保护区（来源：WDPA）",
        description: "海洋保护区（MPAs）是为长期保护而预留的海洋区域。这些区域可以有不同级别的保护，其边界内允许或禁止的活动范围差异很大。来源：世界保护区数据库。最后更新：2021年5月。"
    },
    "public-wpp-nri": {
        name: "世界港口项目国家研究倡议（WPP NRI）",
        description: "WPP-NRI（印度尼西亚共和国国家渔业管理区）是用于捕捞、保护、研究和渔业发展的渔业管理区，涵盖印度尼西亚专属经济区内和外的内陆水域、群岛水域和领海。"
    }
};

var ABW = "阿鲁巴";
var AFG = "阿富汗";
var AGO = "安哥拉";
var AIA = "安圭拉";
var ALA = "奥兰群岛";
var ALB = "阿尔巴尼亚";
var AND = "安道尔";
var ARE = "阿拉伯联合酋长国";
var ARG = "阿根廷";
var ARM = "亚美尼亚";
var ASM = "美属萨摩亚";
var ATA = "南极洲";
var ATF = "法属南部领土";
var ATG = "安提瓜和巴布达";
var AUS = "澳大利亚";
var AUT = "奥地利";
var AZE = "阿塞拜疆";
var BDI = "布隆迪";
var BEL = "比利时";
var BEN = "贝宁";
var BFA = "布基纳法索";
var BGD = "孟加拉国";
var BGR = "保加利亚";
var BHR = "巴林";
var BHS = "巴哈马";
var BIH = "波斯尼亚和黑塞哥维那";
var BLM = "圣巴泰勒米";
var SHN = "圣赫勒拿";
var BLR = "白俄罗斯";
var BLZ = "伯利兹";
var BMU = "百慕大";
var BOL = "玻利维亚（多民族国）";
var BES = "博奈尔、圣尤斯特歇斯和萨巴";
var BRA = "巴西";
var BRB = "巴巴多斯";
var BRN = "文莱";
var BTN = "不丹";
var BVT = "布韦岛";
var BWA = "博茨瓦纳";
var CAF = "中非共和国";
var CAN = "加拿大";
var CCK = "科科斯（基林）群岛";
var CHE = "瑞士";
var CHL = "智利";
var CHN = "中国";
var CIV = "科特迪瓦";
var CMR = "喀麦隆";
var COD = "刚果民主共和国";
var COG = "刚果共和国";
var COK = "库克群岛";
var COL = "哥伦比亚";
var COM = "科摩罗";
var CPV = "佛得角";
var CRI = "哥斯达黎加";
var CUB = "古巴";
var CUW = "库拉索";
var CXR = "圣诞岛";
var CYM = "开曼群岛";
var CYP = "塞浦路斯";
var CZE = "捷克共和国";
var DEU = "德国";
var DJI = "吉布提";
var DMA = "多米尼克";
var DNK = "丹麦";
var DOM = "多米尼加共和国";
var DZA = "阿尔及利亚";
var ECU = "厄瓜多尔";
var EGY = "埃及";
var ERI = "厄立特里亚";
var ESH = "西撒哈拉";
var ESP = "西班牙";
var EST = "爱沙尼亚";
var ETH = "埃塞俄比亚";
var FIN = "芬兰";
var FJI = "斐济";
var FLK = "福克兰群岛（马尔维纳斯）";
var FRA = "法国";
var FRO = "法罗群岛";
var FSM = "密克罗尼西亚联邦";
var GAB = "加蓬";
var GBR = "英国";
var GEO = "格鲁吉亚";
var GGY = "根西岛";
var GHA = "加纳";
var GIB = "直布罗陀";
var GIN = "几内亚";
var GLP = "瓜德罗普";
var GMB = "冈比亚";
var GNB = "几内亚比绍";
var GNQ = "赤道几内亚";
var GRC = "希腊";
var GRD = "格林纳达";
var GRL = "格陵兰";
var GTM = "危地马拉";
var GUF = "法属圭亚那";
var GUM = "关岛";
var GUY = "圭亚那";
var HKG = "香港";
var HMD = "赫德岛和麦克唐纳群岛";
var HND = "洪都拉斯";
var HRV = "克罗地亚";
var HTI = "海地";
var HUN = "匈牙利";
var IDN = "印度尼西亚";
var IMN = "马恩岛";
var IND = "印度";
var IOT = "英属印度洋领地（查戈斯群岛）";
var IRL = "爱尔兰";
var IRN = "伊朗伊斯兰共和国";
var IRQ = "伊拉克";
var ISL = "冰岛";
var ISR = "以色列";
var ITA = "意大利";
var JAM = "牙买加";
var JEY = "泽西岛";
var JOR = "约旦";
var JPN = "日本";
var KAZ = "哈萨克斯坦";
var KEN = "肯尼亚";
var KGZ = "吉尔吉斯斯坦";
var KHM = "柬埔寨";
var KIR = "基里巴斯";
var KNA = "圣基茨和尼维斯";
var KOR = "大韩民国";
var UNK = "科索沃";
var KWT = "科威特";
var LAO = "老挝";
var LBN = "黎巴嫩";
var LBR = "利比里亚";
var LBY = "利比亚";
var LCA = "圣卢西亚";
var LIE = "列支敦士登";
var LKA = "斯里兰卡";
var LSO = "莱索托";
var LTU = "立陶宛";
var LUX = "卢森堡";
var LVA = "拉脱维亚";
var MAC = "澳门";
var MAF = "圣马丁（法属部分）";
var MAR = "摩洛哥";
var MCO = "摩纳哥";
var MDA = "摩尔多瓦共和国";
var MDG = "马达加斯加";
var MDV = "马尔代夫";
var MEX = "墨西哥";
var MHL = "马绍尔群岛";
var MKD = "北马其顿";
var MLI = "马里";
var MLT = "马耳他";
var MMR = "缅甸";
var MNE = "黑山";
var MNG = "蒙古";
var MNP = "北马里亚纳群岛";
var MOZ = "莫桑比克";
var MRT = "毛里塔尼亚";
var MSR = "蒙特塞拉特";
var MTQ = "马提尼克";
var MUS = "毛里求斯";
var MWI = "马拉维";
var MYS = "马来西亚";
var MYT = "马约特岛";
var NAM = "纳米比亚";
var NCL = "新喀里多尼亚";
var NER = "尼日尔";
var NFK = "诺福克岛";
var NGA = "尼日利亚";
var NIC = "尼加拉瓜";
var NIU = "纽埃";
var NLD = "荷兰";
var NOR = "挪威";
var NPL = "尼泊尔";
var NRU = "瑙鲁";
var NZL = "新西兰";
var OMN = "阿曼";
var PAK = "巴基斯坦";
var PAN = "巴拿马";
var PCN = "皮特凯恩群岛";
var PER = "秘鲁";
var PHL = "菲律宾";
var PLW = "帕劳";
var PNG = "巴布亚新几内亚";
var POL = "波兰";
var PRI = "波多黎各";
var PRK = "朝鲜民主主义人民共和国";
var PRT = "葡萄牙";
var PRY = "巴拉圭";
var PSE = "巴勒斯坦";
var PYF = "法属波利尼西亚";
var QAT = "卡塔尔";
var REU = "留尼汪岛";
var ROU = "罗马尼亚";
var RUS = "俄罗斯";
var RWA = "卢旺达";
var SAU = "沙特阿拉伯";
var SDN = "苏丹";
var SEN = "塞内加尔";
var SGP = "新加坡";
var SGS = "南乔治亚和南桑威奇群岛";
var SJM = "斯瓦尔巴和扬马延";
var SLB = "所罗门群岛";
var SLE = "塞拉利昂";
var SLV = "萨尔瓦多";
var SMR = "圣马力诺";
var SOM = "索马里";
var SPM = "圣皮埃尔和密克隆";
var SRB = "塞尔维亚";
var SSD = "南苏丹";
var STP = "圣多美和普林西比";
var SUR = "苏里南";
var SVK = "斯洛伐克";
var SVN = "斯洛文尼亚";
var SWE = "瑞典";
var SWZ = "斯威士兰";
var SXM = "圣马丁（荷属部分）";
var SYC = "塞舌尔";
var SYR = "叙利亚";
var TCA = "特克斯和凯科斯群岛";
var TCD = "乍得";
var TGO = "多哥";
var THA = "泰国";
var TJK = "塔吉克斯坦";
var TKL = "托克劳";
var TKM = "土库曼斯坦";
var TLS = "东帝汶";
var TON = "汤加";
var TTO = "特立尼达和多巴哥";
var TUN = "突尼斯";
var TUR = "土耳其";
var TUV = "图瓦卢";
var TAI = "中国台北";
var TWN = "中国台北";
var TZA = "坦桑尼亚";
var UGA = "乌干达";
var UKR = "乌克兰";
var UMI = "美国本土外小岛屿";
var URY = "乌拉圭";
var USA = "美国";
var UZB = "乌兹别克斯坦";
var VAT = "罗马教廷（梵蒂冈城国）";
var VCT = "圣文森特和格林纳丁斯";
var VEN = "委内瑞拉";
var VGB = "英属维尔京群岛";
var VIR = "美属维尔京群岛";
var VNM = "越南";
var VUT = "瓦努阿图";
var WLF = "瓦利斯和富图纳";
var WSM = "萨摩亚";
var YEM = "也门";
var ZAF = "南非";
var ZMB = "赞比亚";
var ZWE = "津巴布韦";
var flags = {
    ABW: ABW,
    AFG: AFG,
    AGO: AGO,
    AIA: AIA,
    ALA: ALA,
    ALB: ALB,
    AND: AND,
    ARE: ARE,
    ARG: ARG,
    ARM: ARM,
    ASM: ASM,
    ATA: ATA,
    ATF: ATF,
    ATG: ATG,
    AUS: AUS,
    AUT: AUT,
    AZE: AZE,
    BDI: BDI,
    BEL: BEL,
    BEN: BEN,
    BFA: BFA,
    BGD: BGD,
    BGR: BGR,
    BHR: BHR,
    BHS: BHS,
    BIH: BIH,
    BLM: BLM,
    SHN: SHN,
    BLR: BLR,
    BLZ: BLZ,
    BMU: BMU,
    BOL: BOL,
    BES: BES,
    BRA: BRA,
    BRB: BRB,
    BRN: BRN,
    BTN: BTN,
    BVT: BVT,
    BWA: BWA,
    CAF: CAF,
    CAN: CAN,
    CCK: CCK,
    CHE: CHE,
    CHL: CHL,
    CHN: CHN,
    CIV: CIV,
    CMR: CMR,
    COD: COD,
    COG: COG,
    COK: COK,
    COL: COL,
    COM: COM,
    CPV: CPV,
    CRI: CRI,
    CUB: CUB,
    CUW: CUW,
    CXR: CXR,
    CYM: CYM,
    CYP: CYP,
    CZE: CZE,
    DEU: DEU,
    DJI: DJI,
    DMA: DMA,
    DNK: DNK,
    DOM: DOM,
    DZA: DZA,
    ECU: ECU,
    EGY: EGY,
    ERI: ERI,
    ESH: ESH,
    ESP: ESP,
    EST: EST,
    ETH: ETH,
    FIN: FIN,
    FJI: FJI,
    FLK: FLK,
    FRA: FRA,
    FRO: FRO,
    FSM: FSM,
    GAB: GAB,
    GBR: GBR,
    GEO: GEO,
    GGY: GGY,
    GHA: GHA,
    GIB: GIB,
    GIN: GIN,
    GLP: GLP,
    GMB: GMB,
    GNB: GNB,
    GNQ: GNQ,
    GRC: GRC,
    GRD: GRD,
    GRL: GRL,
    GTM: GTM,
    GUF: GUF,
    GUM: GUM,
    GUY: GUY,
    HKG: HKG,
    HMD: HMD,
    HND: HND,
    HRV: HRV,
    HTI: HTI,
    HUN: HUN,
    IDN: IDN,
    IMN: IMN,
    IND: IND,
    IOT: IOT,
    IRL: IRL,
    IRN: IRN,
    IRQ: IRQ,
    ISL: ISL,
    ISR: ISR,
    ITA: ITA,
    JAM: JAM,
    JEY: JEY,
    JOR: JOR,
    JPN: JPN,
    KAZ: KAZ,
    KEN: KEN,
    KGZ: KGZ,
    KHM: KHM,
    KIR: KIR,
    KNA: KNA,
    KOR: KOR,
    UNK: UNK,
    KWT: KWT,
    LAO: LAO,
    LBN: LBN,
    LBR: LBR,
    LBY: LBY,
    LCA: LCA,
    LIE: LIE,
    LKA: LKA,
    LSO: LSO,
    LTU: LTU,
    LUX: LUX,
    LVA: LVA,
    MAC: MAC,
    MAF: MAF,
    MAR: MAR,
    MCO: MCO,
    MDA: MDA,
    MDG: MDG,
    MDV: MDV,
    MEX: MEX,
    MHL: MHL,
    MKD: MKD,
    MLI: MLI,
    MLT: MLT,
    MMR: MMR,
    MNE: MNE,
    MNG: MNG,
    MNP: MNP,
    MOZ: MOZ,
    MRT: MRT,
    MSR: MSR,
    MTQ: MTQ,
    MUS: MUS,
    MWI: MWI,
    MYS: MYS,
    MYT: MYT,
    NAM: NAM,
    NCL: NCL,
    NER: NER,
    NFK: NFK,
    NGA: NGA,
    NIC: NIC,
    NIU: NIU,
    NLD: NLD,
    NOR: NOR,
    NPL: NPL,
    NRU: NRU,
    NZL: NZL,
    OMN: OMN,
    PAK: PAK,
    PAN: PAN,
    PCN: PCN,
    PER: PER,
    PHL: PHL,
    PLW: PLW,
    PNG: PNG,
    POL: POL,
    PRI: PRI,
    PRK: PRK,
    PRT: PRT,
    PRY: PRY,
    PSE: PSE,
    PYF: PYF,
    QAT: QAT,
    REU: REU,
    ROU: ROU,
    RUS: RUS,
    RWA: RWA,
    SAU: SAU,
    SDN: SDN,
    SEN: SEN,
    SGP: SGP,
    SGS: SGS,
    SJM: SJM,
    SLB: SLB,
    SLE: SLE,
    SLV: SLV,
    SMR: SMR,
    SOM: SOM,
    SPM: SPM,
    SRB: SRB,
    SSD: SSD,
    STP: STP,
    SUR: SUR,
    SVK: SVK,
    SVN: SVN,
    SWE: SWE,
    SWZ: SWZ,
    SXM: SXM,
    SYC: SYC,
    SYR: SYR,
    TCA: TCA,
    TCD: TCD,
    TGO: TGO,
    THA: THA,
    TJK: TJK,
    TKL: TKL,
    TKM: TKM,
    TLS: TLS,
    TON: TON,
    TTO: TTO,
    TUN: TUN,
    TUR: TUR,
    TUV: TUV,
    TAI: TAI,
    TWN: TWN,
    TZA: TZA,
    UGA: UGA,
    UKR: UKR,
    UMI: UMI,
    URY: URY,
    USA: USA,
    UZB: UZB,
    VAT: VAT,
    VCT: VCT,
    VEN: VEN,
    VGB: VGB,
    VIR: VIR,
    VNM: VNM,
    VUT: VUT,
    WLF: WLF,
    WSM: WSM,
    YEM: YEM,
    ZAF: ZAF,
    ZMB: ZMB,
    ZWE: ZWE
};

var playback = {
    playAnimation: "播放动画",
    pauseAnimation: "暂停动画",
    toogleAnimationLooping: "切换动画循环",
    moveBack: "向后移动",
    moveForward: "向前移动",
    changeAnimationSpeed: "更改动画速度"
};
var timerange = {
    title: "选择时间范围",
    year: "年",
    month: "月",
    day: "日",
    start: "开始",
    end: "结束",
    selectAValidDate: "请选择有效的日期",
    endBeforeStart: "结束时间需要在开始时间之后",
    tooLongForMonths: "您的时间范围太长，无法查看单个月份",
    tooLongForDays: "您的时间范围太长，无法查看单个日期",
    last30days: "过去30天",
    last3months: "过去3个月",
    last6months: "过去6个月",
    lastYear: "过去1年",
    done: "完成",
    errorEarlyStart: "您的开始日期是可用数据的最早日期。",
    errorLatestEnd: "您的结束日期是可用数据的最新日期。",
    errorMinRange: "您的开始日期和结束日期必须至少相隔一天。",
    errorMaxRange: "您的时间范围是可用数据的最大范围。"
};
var bookmark = {
    goToBookmark: "转到您的书签时间范围",
    deleteBookmark: "删除时间范围书签"
};
var trackEvents = {
    events: "事件"
};
var dragLabel = "拖动以更改时间范围";
var lastUpdate = "最后更新";
var setBookmark = "书签当前时间范围";
var intervals = {
    hour: "小时",
    hourTooltip: "查看小时数据",
    day: "天",
    dayTooltip: "查看每日数据",
    month: "月",
    monthTooltip: "查看月度数据",
    year: "年",
    yearTooltip: "查看年度数据"
};
var zoomTo = "缩放至";
var timebar = {
    playback: playback,
    timerange: timerange,
    bookmark: bookmark,
    trackEvents: trackEvents,
    dragLabel: dragLabel,
    lastUpdate: lastUpdate,
    setBookmark: setBookmark,
    intervals: intervals,
    zoomTo: zoomTo
};

exports.datasets = datasets;
exports.flags = flags;
exports.timebar = timebar;
